/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.response;

import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.CommandResponse;
import ru.softlogic.hardware.device.cdm.f56.response.data.CasseteData;
import ru.softlogic.hardware.device.cdm.f56.response.data.ErrorReg;
import ru.softlogic.io.utils.BU;

public class ResponseBasic<T extends CommandResponse> {
    private int dh0;
    private int dh1;
    private int dh2;
    private int errorCode;
    private int errorAddr;
    private int v1;
    private int v2;
    private ErrorReg errorReg;
    private final byte[] sensorReg = new byte[6];
    private final CasseteData[] cassets = new CasseteData[4];
    private int pomLevel;
    private final T commandSpecifiedData;

    public ResponseBasic(T commandSpecifiedData) {
        this.commandSpecifiedData = commandSpecifiedData;
    }

    public void initData(byte[] data) {
        this.dh0 = BU.c((byte)data[0]);
        this.dh1 = BU.c((byte)data[1]);
        this.dh2 = BU.c((byte)data[2]);
        this.errorCode = BU.csbe((byte[])data, (int)3);
        this.errorAddr = BU.csbe((byte[])data, (int)5);
        this.v1 = BU.c((byte)data[7]);
        this.v2 = BU.c((byte)data[8]);
        this.errorReg = new ErrorReg(BU.csle((byte[])data, (int)9) << 8 | BU.c((byte)data[11]));
        System.arraycopy(data, 12, this.sensorReg, 0, this.sensorReg.length);
        this.pomLevel = BU.c((int)22);
        int casRegPos = 18;
        int lenMaxPos = 23;
        int lenMinPos = 24;
        int thickPos = 31;
        int statChangesPos = 35;
        for (int i = 0; i < this.cassets.length; ++i) {
            this.cassets[i] = new CasseteData(BU.c((byte)data[i + casRegPos]), BU.c((byte)data[i * 2 + lenMinPos]), BU.c((byte)data[i * 2 + lenMaxPos]), BU.c((byte)data[i + thickPos]), BU.c((byte)data[i + statChangesPos]));
        }
        this.commandSpecifiedData.init(data, 39);
    }

    public int getDh0() {
        return this.dh0;
    }

    public int getDh1() {
        return this.dh1;
    }

    public int getDh2() {
        return this.dh2;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorAddr() {
        return this.errorAddr;
    }

    public int getV1() {
        return this.v1;
    }

    public int getV2() {
        return this.v2;
    }

    public ErrorReg getErrorReg() {
        return this.errorReg;
    }

    public byte[] getSensorReg() {
        return this.sensorReg;
    }

    public CasseteData[] getCassets() {
        return this.cassets;
    }

    public int getPomLevel() {
        return this.pomLevel;
    }

    public T getCommandSpecifiedData() {
        return this.commandSpecifiedData;
    }

    public String toString() {
        return "ResponseBasic{dh0=" + String.format("%02x", this.dh0) + ", dh1=" + String.format("%02x", this.dh1) + ", dh2=" + String.format("%02x", this.dh2) + ", errorCode=" + String.format("%04x", this.errorCode) + ", errorAddr=" + String.format("%04x", this.errorAddr) + ", v1=" + this.v1 + ", v2=" + this.v2 + ", errorReg=" + this.errorReg + ", sensorReg=" + BU.toString((byte[])this.sensorReg) + ", pomLevel=" + this.pomLevel + '}';
    }
}

