/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.request.command;

import java.io.IOException;
import ru.softlogic.hardware.device.cdm.f56.connector.ByteOperator;
import ru.softlogic.hardware.device.cdm.f56.request.BasicRequest;
import ru.softlogic.io.utils.BU;

public class DemandInit
extends BasicRequest {
    private int param;
    int[] billLenL = new int[4];
    int[] billLenH = new int[4];
    int[] billThick = new int[4];

    public DemandInit() {
        super(96, 2, 13);
    }

    public void setBillMin(int box, int lenMin) {
        this.billLenL[box] = lenMin;
    }

    public void setBillMax(int box, int lenMax) {
        this.billLenH[box] = lenMax;
    }

    public void setBillThick(int box, int billThick) {
        this.billThick[box] = billThick;
    }

    public void setBillSpecification(BillSPecification spec) {
        this.param = this.param & 0x3F | spec.getCode() << 6;
    }

    public void setShutterAction(Shutter shutter, ShutterAction action) {
        int pos = 1 << shutter.getNumber();
        this.param = this.param & ~pos | action.getCode() << shutter.getNumber();
    }

    @Override
    protected void sendDataRegion(ByteOperator op) throws IOException {
        op.operate(BU.c((int)this.param));
        op.operate(BU.c((int)this.billLenH[0]));
        op.operate(BU.c((int)this.billLenL[0]));
        op.operate(BU.c((int)this.billLenH[1]));
        op.operate(BU.c((int)this.billLenL[1]));
        op.operate(BU.c((int)this.billLenH[2]));
        op.operate(BU.c((int)this.billLenL[2]));
        op.operate(BU.c((int)this.billLenH[3]));
        op.operate(BU.c((int)this.billLenL[3]));
        op.operate(BU.c((int)this.billThick[0]));
        op.operate(BU.c((int)this.billThick[1]));
        op.operate(BU.c((int)this.billThick[2]));
        op.operate(BU.c((int)this.billThick[3]));
    }

    public static enum ShutterAction {
        OpenOrClose(0),
        NoAction(1);

        int code;

        private ShutterAction(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum Shutter {
        Front(0),
        Rear(1);

        int number;

        private Shutter(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }
    }

    public static enum BillSPecification {
        Normal(0),
        Australlian(1);

        int code;

        private BillSPecification(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

