/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.request.command;

import java.io.IOException;
import ru.softlogic.hardware.device.cdm.f56.NumberUtil;
import ru.softlogic.hardware.device.cdm.f56.connector.ByteOperator;
import ru.softlogic.hardware.device.cdm.f56.request.BasicRequest;
import ru.softlogic.io.utils.BU;

public class BillCount
extends BasicRequest {
    private int order;
    private final int[] billsCount = new int[4];
    private final int[] rejectsCount = new int[4];
    private final int[] pickRetriesCount = new int[4];

    public BillCount() {
        super(96, 3, 21);
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setBillsCount(int box, int count) {
        this.billsCount[box] = count;
    }

    public void setRejectsCount(int box, int count) {
        this.rejectsCount[box] = count;
    }

    public void setPickRetriesCount(int box, int count) {
        this.pickRetriesCount[box] = count;
    }

    @Override
    protected void sendDataRegion(ByteOperator op) throws IOException {
        byte[] decNum;
        int i;
        op.operate(BU.c((int)this.order));
        for (i = 0; i < 4; ++i) {
            decNum = NumberUtil.totwoDigitDecimal(this.billsCount[i]);
            op.operate(decNum[0]);
            op.operate(decNum[1]);
        }
        for (i = 0; i < 4; ++i) {
            decNum = NumberUtil.totwoDigitDecimal(this.rejectsCount[i]);
            op.operate(decNum[0]);
            op.operate(decNum[1]);
        }
        for (i = 0; i < 4; ++i) {
            op.operate(BU.c((int)this.pickRetriesCount[i]));
        }
    }
}

