/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.stub;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.DriverControl;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;

public class DriverManual
extends Validator {
    private final DriverControl control;
    private final DeviceInfo info = new DeviceInfo(DeviceType.ValidatorStubManual);
    private final String key;
    private final Map<Integer, Sum> sumMap;

    public DriverManual() {
        super("cashin");
        this.info.setVendor("N/A");
        this.info.setPort("N/A");
        this.key = SystemProp.getCashinStubKey();
        this.control = new LocalDriverControl();
        this.sumMap = new HashMap<Integer, Sum>();
        this.sumMap.put(1, new Sum(10.0));
        this.sumMap.put(2, new Sum(50.0));
        this.sumMap.put(3, new Sum(100.0));
        this.sumMap.put(4, new Sum(500.0));
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        this.log.info((Object)"onRecover");
        this.notifyStatus(ValidatorStatus.Init);
        this.notifyStatus(ValidatorStatus.Ok);
    }

    public DriverControl getDriverControl() {
        return this.control;
    }

    public String toString() {
        return "ValidatorStubManual{}";
    }

    class LocalDriverControl
    implements DriverControl {
        LocalDriverControl() {
        }

        public void onNote(int id) {
            Sum s;
            if (DriverManual.this.enable && "dYksJPW8GVLu762Zldyp".equals(DriverManual.this.key) && (s = (Sum)DriverManual.this.sumMap.get(id)) != null) {
                DriverManual.this.log.info((Object)("On protected note: " + id));
                if (DriverManual.this.cashStorage.cashPermit(new CashUnit(id, s, 3))) {
                    DriverManual.this.notifyCash(new CashUnit(-id, s, 3));
                    DriverManual.this.cashStorage.addCash(new CashUnit(id, s, 3));
                }
            }
        }

        public void onProtectedNote(int id) {
            Sum s;
            if (DriverManual.this.enable && (s = (Sum)DriverManual.this.sumMap.get(id)) != null) {
                DriverManual.this.log.info((Object)("On note: " + id));
                if (DriverManual.this.cashStorage.cashPermit(new CashUnit(id, s, 3))) {
                    DriverManual.this.notifyCash(new CashUnit(-id, s, 3));
                    DriverManual.this.cashStorage.addCash(new CashUnit(-id, s, 3));
                }
            }
        }

        public void onFroudNote(int id) {
            Sum s;
            if (DriverManual.this.enable && "dYksJPW8GVLu762Zldyp".equals(DriverManual.this.key) && (s = (Sum)DriverManual.this.sumMap.get(id)) != null) {
                DriverManual.this.log.info((Object)("On froud note: " + id));
                if (DriverManual.this.cashStorage.cashPermit(new CashUnit(id, s, 3))) {
                    DriverManual.this.notifyCash(new CashUnit(-id, s, 3));
                    DriverManual.this.cashStorage.addCash(new CashUnit(id, s, 3));
                    DriverManual.this.notifyEvent(Event.CommonReject);
                }
            }
        }

        public void onStackOut() {
            DriverManual.this.log.info((Object)"onStackOut");
            DriverManual.this.notifyStatus(ValidatorStatus.StackOut);
        }

        public void onJamm() {
            DriverManual.this.log.info((Object)"onJamm");
            DriverManual.this.notifyStatus(ValidatorStatus.JammInStack);
        }

        public void onRecover() {
            DriverManual.this.log.info((Object)"onRecover");
            DriverManual.this.notifyStatus(ValidatorStatus.Ok);
        }
    }
}

