/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.statistics;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.Statistics;
import ru.softlogic.hardware.device.cashin.validator.statistics.StoreData;
import ru.softlogic.sequence.Sequence;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class StatisticStore {
    private final File file;
    private StoreData sd;
    private DeviceClass deviceClass;
    private Logger log;

    public StatisticStore(String fileName, DeviceClass deviceClass) throws FileUtilException {
        this.file = FileUtil.checkFile((String)fileName);
        if (deviceClass == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DeviceClass");
        }
        if (deviceClass != DeviceClass.CashAcceptor && deviceClass != DeviceClass.CoinAcceptor) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 DeviceClass");
        }
        this.deviceClass = deviceClass;
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
        this.readData();
    }

    public synchronized void addEvent(Event event) {
        Map<Event, Integer> stat = this.sd.getStat();
        if (stat.get((Object)event) == null) {
            stat.put(event, 1);
        } else {
            stat.put(event, stat.get((Object)event) + 1);
        }
        this.saveData();
    }

    public synchronized Statistics resetStatistics() {
        this.log.info((Object)"\u041e\u0431\u043d\u0443\u043b\u044f\u044e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443");
        StoreData newSd = new StoreData();
        int id = 0;
        try {
            Sequence seq = SequenceManager.getInstance().getSequence("statistics-id");
            id = seq.next();
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438", (Throwable)ex);
        }
        Statistics st = new Statistics(id, this.sd.getFrom(), newSd.getFrom(), this.deviceClass.getCode());
        Map<Event, Integer> stat = this.sd.getStat();
        Integer countProgramReject = stat.get((Object)Event.ProgramReject) != null ? stat.get((Object)Event.ProgramReject) : 0;
        if (stat.get((Object)Event.Insert) != null) {
            st.setTotal(stat.get((Object)Event.Insert) - countProgramReject);
        }
        if (stat.get((Object)Event.OpticErrorReject) != null) {
            st.setOpticReject(stat.get((Object)Event.OpticErrorReject));
        }
        if (stat.get((Object)Event.TransportErrorReject) != null) {
            st.setTransportReject(stat.get((Object)Event.TransportErrorReject));
        }
        if (stat.get((Object)Event.CommonReject) != null) {
            st.setCommonReject(stat.get((Object)Event.CommonReject));
        }
        this.sd = newSd;
        this.saveData();
        return st;
    }

    public Date getFrom() {
        return this.sd.getFrom();
    }

    private void readData() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.file));
            Object obj = ois.readObject();
            if (obj instanceof StoreData) {
                this.sd = (StoreData)obj;
            }
        }
        catch (EOFException obj) {
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.sd == null) {
            this.sd = new StoreData();
        }
    }

    private void saveData() {
        ObjectOutputStream oos = null;
        this.log.debug((Object)("save new data: " + this.sd));
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.sd);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

