/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.itl;

import java.io.IOException;
import java.util.Arrays;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.proto.essp.Banknote;
import ru.softlogic.hardware.proto.essp.Crc16;
import ru.softlogic.hardware.proto.essp.Nv200Api;
import ru.softlogic.hardware.proto.essp.SSPApi;
import ru.softlogic.hardware.proto.essp.SSPException;
import ru.softlogic.hardware.proto.essp.SSPLayer;
import ru.softlogic.hardware.proto.essp.ValidatorSetup;
import ru.softlogic.hardware.proto.essp.eSSPException;
import ru.softlogic.hardware.proto.essp.m;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class SspDriver
extends Validator {
    private final SerialPort port;
    private final SSPApi api;
    private Nv200Api nvApi;
    private final DeviceInfo info;
    private ValidatorSetup setup;
    private boolean localEnabled;
    private byte[] last;
    private CashUnit unit;
    private boolean locked;

    public SspDriver(SerialPort port, DeviceType type) {
        super("cashin");
        this.port = port;
        this.info = new DeviceInfo(type);
        this.info.setVendor("ITL");
        this.info.setPort(port.getName());
        this.api = new SSPApi(port, 0, this.log);
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start");
        this.log.info((Object)("Port: " + this.port.getName()));
        this.log.info((Object)("Params: " + this.port.getParams()));
        this.log.info((Object)("Driver: " + this.info.getDeviceType()));
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    byte[] data;
                    if (this.nvApi == null) {
                        this.init();
                    }
                    if (this.enable != this.localEnabled) {
                        if (this.enable) {
                            this.nvApi.enable();
                            this.nvApi.setChannelInhibits(255);
                        } else {
                            this.nvApi.disable();
                            this.nvApi.setChannelInhibits(0);
                        }
                        this.localEnabled = this.enable;
                    }
                    if ((data = this.nvApi.poll()) == null || data.length == 0 || Arrays.equals(data, this.last)) {
                        Thread.sleep(200L);
                        continue;
                    }
                    this.last = data;
                    block26: for (int i = 0; i < data.length; ++i) {
                        switch (BU.c((byte)data[i])) {
                            case 241: {
                                this.log.info((Object)"Slave reset");
                                continue block26;
                            }
                            case 239: {
                                int channel = BU.c((byte)data[++i]);
                                this.log.info((Object)("Read: " + channel));
                                if (channel == 0) {
                                    this.log.info((Object)"Accepting");
                                    this.notifyEvent(Event.Insert);
                                    this.log.info((Object)"Accepting1");
                                    this.lock();
                                    this.log.info((Object)"Accepting2");
                                    continue block26;
                                }
                                this.log.info((Object)("Accepting: " + this.get(channel)));
                                continue block26;
                            }
                            case 238: {
                                int channel = BU.c((byte)data[++i]);
                                this.unit = this.get(channel);
                                this.log.info((Object)("Credit: " + channel + ", unit=" + this.unit));
                                continue block26;
                            }
                            case 237: {
                                this.log.info((Object)"Rejecting");
                                this.unlock();
                                continue block26;
                            }
                            case 236: {
                                this.log.info((Object)"Rejected");
                                this.unlock();
                                this.notifyEvent(Event.CommonReject);
                                int code = this.nvApi.getLastRejectCode();
                                this.log.info((Object)("Reject cause: " + m.getRejectError(code)));
                                continue block26;
                            }
                            case 204: {
                                this.log.info((Object)"Stacking");
                                continue block26;
                            }
                            case 235: {
                                this.log.info((Object)"Stacked");
                                this.log.info((Object)"Notify cash storage");
                                this.cashStorage.addCash(this.unit);
                                this.notifyCash(this.unit);
                                this.log.info((Object)("Bill stacked " + this.unit));
                                this.unlock();
                                continue block26;
                            }
                            case 234: {
                                this.log.info((Object)"Safe jam");
                                this.notifyStatus(ValidatorStatus.JammInHead);
                                this.unlock();
                                continue block26;
                            }
                            case 233: {
                                this.log.info((Object)"Unsafe jam");
                                this.notifyStatus(ValidatorStatus.JammInHead);
                                this.unlock();
                                continue block26;
                            }
                            case 232: {
                                this.log.info((Object)"Disabled");
                                this.unlock();
                                this.notifyStatus(ValidatorStatus.Ok);
                                continue block26;
                            }
                            case 230: {
                                int channel = BU.c((byte)data[++i]);
                                this.log.info((Object)("Fraud: " + channel));
                                continue block26;
                            }
                            case 231: {
                                this.unlock();
                                this.notifyStatus(ValidatorStatus.StackOverflow);
                                continue block26;
                            }
                            case 225: {
                                int channel = BU.c((byte)data[++i]);
                                this.log.info((Object)("Note cleared front " + channel));
                                continue block26;
                            }
                            case 226: {
                                int channel = BU.c((byte)data[++i]);
                                this.log.info((Object)("Note cleared box: " + channel));
                                continue block26;
                            }
                            case 227: {
                                this.log.info((Object)"Box removed");
                                continue block26;
                            }
                            case 228: {
                                this.log.info((Object)"Box replaced");
                                continue block26;
                            }
                            default: {
                                this.log.error((Object)("Unknown state: " + BU.c((byte)data[i])));
                            }
                        }
                    }
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    this.unlock();
                    this.log.error((Object)ex, (Throwable)ex);
                    this.nvApi = null;
                    this.api.close();
                    this.notifyStatus(ValidatorStatus.ConnectionError);
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.log.debug((Object)"Stop thread");
            this.api.close();
        }
    }

    private void lock() throws InterruptedException {
        if (!this.locked) {
            this.mutex.lock();
            this.locked = true;
        }
    }

    private void unlock() {
        this.mutex.unlock();
        this.locked = false;
    }

    private void init() throws IOException, eSSPException, SSPException {
        this.log.info((Object)"Open port");
        this.api.open();
        this.log.info((Object)("Sync: " + m.get(this.api.sync())));
        this.log.info((Object)("Serial: " + this.api.getSerial()));
        this.log.info((Object)("Firmware: " + this.api.getFirmware()));
        this.log.info((Object)("Unit type: " + this.api.getUnitType()));
        this.nvApi = new Nv200Api(new SSPLayer(this.port, new Crc16(), this.log), 0, 6, this.log);
        this.nvApi.disable();
        this.nvApi.setChannelInhibits(0);
        this.log.info((Object)"Get device setup:");
        this.setup = this.nvApi.getDeviceSetup();
        this.log.info((Object)("   Firmware: " + this.setup.getFirmvare()));
        this.log.info((Object)("   Country: " + this.setup.getMainCountryCode()));
        this.log.info((Object)("   Multiplier: " + this.setup.getMuliplier()));
        this.log.info((Object)("   Proto: " + this.setup.getProto()));
        this.log.info((Object)("   Secures: " + Arrays.toString(this.setup.getSecures())));
        this.log.info((Object)"   Banknotes: ");
        for (Banknote bn : this.setup.getBanknotes()) {
            this.log.info((Object)("      " + bn.toString()));
        }
        this.log.info((Object)"-------");
    }

    private CashUnit get(int channel) {
        Banknote bn = this.setup.getBanknotes()[channel - 1];
        this.log.info((Object)("Banknote: " + bn));
        return CashFactory.getDefaultInstance().getCashUnitByNominal(new Sum(1.0 * (double)bn.getNominal()));
    }
}

