/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ict004;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.ict004.IctStatus;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Ict004Api
implements ValidatorApi {
    private SerialParams[] serialParams;
    private SerialPort serialPort;
    private Logger log;

    public Ict004Api(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)};
        this.log = Logger.getLogger((String)"cashin");
    }

    @Override
    public final SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.serialPort.putParams(params);
                    this.open();
                    this.disable();
                    if (this.poll().getStatus() != 94) continue;
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public final DeviceType getDeviceType() {
        return DeviceType.Ict004;
    }

    @Override
    public final void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
        this.serialPort.setDTR(true);
    }

    @Override
    public final void close() {
        this.serialPort.close();
    }

    public final IctStatus poll() throws IOException {
        this.serialPort.flush(Flush.RxTx);
        this.serialPort.setTimeout(1000);
        this.log.debug((Object)">>0x0c");
        this.serialPort.write((byte)12);
        int res = this.serialPort.readByte();
        this.log.debug((Object)String.format("<< %02x", res));
        return new IctStatus(res, 0);
    }

    public final void pollRequest() throws IOException {
        this.serialPort.setTimeout(1000);
        this.log.debug((Object)">>0x0c");
        this.serialPort.write((byte)12);
    }

    public final IctStatus getStatus() throws IOException {
        if (this.serialPort.avaliable() > 0) {
            this.serialPort.setTimeout(1000);
            int res = this.serialPort.readByte();
            this.log.debug((Object)String.format("<< %02x", res));
            if (res == 128 || res == 129 || res == 130) {
                return new IctStatus(res, this.serialPort.readByte());
            }
            return new IctStatus(res, 0);
        }
        return null;
    }

    public final IctStatus getStackResult() {
        this.serialPort.setTimeout(1000);
        for (int i = 0; i < 60; ++i) {
            try {
                int res = this.serialPort.readByte();
                if (res == 62) continue;
                return new IctStatus(res, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public final void stackCash() throws IOException {
        this.log.debug((Object)">>0x02");
        this.sendCommand((byte)2);
    }

    public final void returnCash() throws IOException {
        this.log.debug((Object)">>0x0f");
        this.sendCommand((byte)15);
    }

    public final void enable() throws IOException {
        this.log.debug((Object)">>0x3e");
        this.sendCommand((byte)62);
    }

    public final void disable() throws IOException {
        this.log.debug((Object)">>0x5c");
        this.sendCommand((byte)94);
    }

    public final void handleResponse() throws IOException {
        this.log.debug((Object)">>0x02");
        this.sendCommand((byte)2);
    }

    public final void reset() throws IOException {
        this.log.debug((Object)">>0x30");
        this.sendCommand((byte)48);
    }

    private void sendCommand(byte command) throws IOException {
        this.serialPort.setTimeout(1000);
        this.serialPort.write(command);
    }

    @Override
    public void test() throws IOException {
        this.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        return new ValidatorInfo("-");
    }
}

