/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.gpt22;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.device.cashin.validator.gpt22.Connector;
import ru.softlogic.hardware.device.cashin.validator.gpt22.GptStatus;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class Gpt22Api
implements ValidatorApi {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Gpt22Api.class.getPackage().getName() + ".messages");
    public static final int MODE_POLLED = 1;
    public static final int MODE_ESCROW = 2;
    private final Connector conn;
    private final Logger log;
    private SerialPort serialPort;

    public Gpt22Api(SerialPort port, Logger log) {
        this.conn = new Connector(port, log);
        this.log = log;
        this.serialPort = port;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void setSerialPort(SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    @Override
    public void open() throws IOException {
        this.conn.open();
    }

    @Override
    public void close() {
        this.conn.close();
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void reset() throws IOException {
        this.conn.sendMessage(54);
    }

    public void resetUnitSetup() throws IOException {
        this.conn.sendMessage(53);
    }

    public void resetStatistics() throws IOException {
        this.conn.sendMessage(50);
    }

    public void resetBillCounter() throws IOException {
        this.conn.sendMessage(52);
    }

    public void setInhibit(boolean inhibit) throws IOException {
        this.conn.sendMessage(inhibit ? 240 : 241);
    }

    public void setMode(int mode) throws IOException {
        this.conn.sendMessage(64, new byte[]{BU.c((int)mode)});
    }

    public void requestMode() throws IOException {
        this.conn.sendMessage(192);
    }

    public GptStatus requestStatus() throws IOException {
        byte[] res = this.conn.sendMessage(204);
        try {
            if (res.length == 3) {
                return new GptStatus(res, null);
            }
            byte[] st = new byte[3];
            System.arraycopy(res, 0, st, 0, 3);
            byte[] bar = new byte[res.length - 3];
            System.arraycopy(res, 3, bar, 0, bar.length);
            return new GptStatus(st, bar);
        }
        catch (Throwable ex) {
            this.log.error((Object)("dd=" + BU.toString((byte[])res)));
            throw new IOException(ex);
        }
    }

    public void setStackerRequire(boolean require) throws IOException {
        this.conn.sendMessage(require ? 70 : 69);
    }

    public void setBillEnables(int mask) throws IOException {
        this.conn.sendMessage(65, new byte[]{BU.c((int)mask), BU.c((int)(mask >> 8))});
    }

    public void requestBillEnables() throws IOException {
        this.conn.sendMessage(193);
    }

    public void setSecurityLevel(int mask) throws IOException {
        this.conn.sendMessage(66, new byte[]{BU.c((int)mask), BU.c((int)(mask >> 8))});
    }

    public void acceptBill() throws IOException {
        this.conn.sendMessage(128);
    }

    public void returnBill() throws IOException {
        this.conn.sendMessage(129);
    }

    public String requestSerial() throws IOException {
        return this.bcdToString(this.conn.sendMessage(210));
    }

    public String requestAssetNumber() throws IOException {
        return this.bcdToString(this.conn.sendMessage(211));
    }

    public String requestFactoryNumber() throws IOException {
        return this.bcdToString(this.conn.sendMessage(212));
    }

    public String requestProgramRevision() throws IOException {
        return BU.safeConvert((byte[])this.conn.sendMessage(216)).trim();
    }

    public Date requestProductionDate() throws IOException {
        byte[] res = this.conn.sendMessage(213);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2000 + this.bcdToInt(res[0]));
        cal.set(3, this.bcdToInt(res[1]));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void debugData(GptStatus s) {
        this.log.info((Object)((s.isBillStacked() ? "*stcd" : "     ") + " " + (s.isEscrow() ? "*escd" : "     ") + "" + (s.isInvalidEscrow() ? "+inld" : "") + " " + (s.isBillReturned() ? "*retd" : "     ") + " " + (s.isIdle() ? "*idl" : "    ") + " " + (s.isAccepting() ? "*accg" : "     ") + " " + (s.isStacking() ? "*stcg" : "     ") + " " + (s.isCheat() ? "*che" : "    ") + " " + (s.isReturning() ? "*retg" : "     ") + " " + (s.isRejecting() ? "*rejg" : "     ") + " " + (s.isPowerOn() ? "*pon" : "    ") + "" + (s.isUpWithBill() ? "+wbil" : "") + " " + (s.isInhibit() ? "*ihb" : "    ") + " " + (s.isDisabled() ? "*dis" : "    ") + " " + (s.isTimeOut() ? "*to" : "   ") + " " + (s.isStackerFull() ? "*sful" : "     ") + " " + (s.isStackerOff() ? "*soff" : "     ") + " " + (s.isStackerJamm() ? "*sjam" : "     ") + " " + (s.isBillJam() ? "*bjam" : "     ") + "" + (s.getBillType() != null ? "|Bill type: " + s.getBillType() : "") + (s.getRejectingCode() != null ? "|Reject code: " + BU.toHex((int)s.getRejectingCode()) + "," + this.getRejectMessage(s.getRejectingCode()) : "")));
    }

    public String getRejectMessage(int code) {
        try {
            return bundle.getString("reject." + String.format("%02X", code));
        }
        catch (Throwable throwable) {
            return "Unknown state " + code;
        }
    }

    public String getErrorMessage(int error) {
        try {
            return bundle.getString("error." + String.format("%02X", error));
        }
        catch (Throwable throwable) {
            return "Unknown state " + error;
        }
    }

    private int bcdToInt(byte d) {
        return Integer.parseInt(String.format("%02x", d));
    }

    private String bcdToString(byte[] d) {
        StringBuilder sb = new StringBuilder();
        for (byte b : d) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    @Override
    public void test() throws IOException {
        this.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        String serialNumber = this.requestProgramRevision();
        return new ValidatorInfo("GPT Protocol v2.2. SN: " + serialNumber);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.getAvailableParameters()) {
            try {
                this.serialPort.putParams(params);
                this.open();
                this.reset();
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.conn.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.getSerialPort().getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.GPT22;
    }
}

