/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.util.Arrays;
import ru.softlogic.hardware.utils.ByteUtils;

public class EbdsStatus {
    public static final EbdsStatus EMPTY = new EbdsStatus(new byte[7], null);
    private byte[] data;
    private byte[] extendedData;

    public EbdsStatus(byte[] data, byte[] extendedData) {
        if (data == null || data.length != 7) {
            throw new IllegalArgumentException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 7 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        this.data = data;
        this.extendedData = extendedData;
    }

    public boolean isIdling() {
        return (this.data[1] & 1) != 0;
    }

    public boolean isAccepting() {
        return (this.data[1] & 2) != 0;
    }

    public boolean isEscrowed() {
        return (this.data[1] & 4) != 0;
    }

    public boolean isStacking() {
        return (this.data[1] & 8) != 0;
    }

    public boolean isStacked() {
        return (this.data[1] & 0x10) != 0;
    }

    public boolean isReturning() {
        return (this.data[1] & 0x20) != 0;
    }

    public boolean isReturned() {
        return (this.data[1] & 0x40) != 0;
    }

    public boolean isCheated() {
        return (this.data[2] & 1) != 0;
    }

    public boolean isRejected() {
        return (this.data[2] & 2) != 0;
    }

    public boolean isJammed() {
        return (this.data[2] & 4) != 0;
    }

    public boolean isStackerFull() {
        return (this.data[2] & 8) != 0;
    }

    public boolean isCassetteAttached() {
        return (this.data[2] & 0x10) != 0;
    }

    public boolean isPaused() {
        return (this.data[2] & 0x20) != 0;
    }

    public boolean isCalibration() {
        return (this.data[2] & 0x40) != 0;
    }

    public boolean isPowerUp() {
        return (this.data[3] & 1) != 0;
    }

    public boolean isInvalidCommand() {
        return (this.data[3] & 2) != 0;
    }

    public boolean isFailure() {
        return (this.data[3] & 4) != 0;
    }

    public int getBillCode() {
        return (this.data[3] & 0xF8) >> 3;
    }

    public byte[] getExtendedData() {
        return this.extendedData;
    }

    public boolean isFlashDownload() {
        return (this.data[4] & 2) != 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "EbdsStatus{data=" + ByteUtils.toString(this.data) + ", ext=" + ByteUtils.toString(this.extendedData) + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EbdsStatus other = (EbdsStatus)obj;
        if (this.data == other.data) {
            return true;
        }
        int length = this.data.length;
        if (other.data.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!(i == 0 ? (this.data[0] & 0xF0) != (other.data[0] & 0xF0) : this.data[i] != other.data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Arrays.hashCode(this.data);
        return hash;
    }
}

