/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class EbdsConnection {
    public static final int CMD_OMNIBUS = 16;
    public static final int CMD_DOWNLOAD = 80;
    public static final int CMD_AUXILIARY = 96;
    public static final int CMD_EXTENDED = 112;
    private static final byte STX = 2;
    private static final byte ETX = 3;
    private static final int MAX_LEN = 20;
    private static final int TIMEOUT = 400;
    private int attempts = 5;
    private int attemptsTimeout = 2000;
    private SerialPort port;
    private Logger log;
    private int flag = 0;

    public void reverseFlag() {
        this.flag ^= 1;
    }

    public EbdsConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"cashin");
        this.log.setAdditivity(false);
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public int getAttemptsTimeout() {
        return this.attemptsTimeout;
    }

    public void setAttemptsTimeout(int attemptsTimeout) {
        this.attemptsTimeout = attemptsTimeout;
    }

    public void sendReset() throws IOException {
        this.port.flush(Flush.RxTx);
        byte[] request = this.formMessage(96 + this.flag, new byte[]{127, 127, 127});
        this.port.setTimeout(200);
        this.port.write(request);
        this.log.debug((Object)(">>" + ByteUtils.toString(request)));
        this.flag ^= 1;
        this.port.setTimeout(400);
        int b = 0;
        try {
            b = this.port.readByte();
            this.log.debug((Object)("Byte: " + String.format("0x%02x", b)));
        }
        catch (IOException ex) {
            return;
        }
        this.port.flush(Flush.RxTx);
        b = this.port.readByte();
        this.log.debug((Object)("Byte: " + String.format("0x%02x", b)));
        this.port.setTimeout(200);
        request = this.formMessage(96 + this.flag, new byte[]{127, 127, 127});
        this.port.write(request);
        this.log.debug((Object)(">>" + ByteUtils.toString(request)));
        try {
            b = this.port.readByte();
            this.log.debug((Object)("Byte: " + String.format("0x%02x", b)));
        }
        catch (IOException ex) {
            return;
        }
    }

    public byte[] sendCommand(int ctl, byte[] data, Integer timeout) throws IOException {
        return this.sendCommand(ctl, data, timeout, this.attempts);
    }

    public byte[] sendCommand(int ctl, byte[] data, Integer timeout, int attemptsNumber) throws IOException {
        int to = timeout == null ? 400 : timeout;
        byte[] responce = this._sendCommand(ctl + this.flag, data, to, attemptsNumber);
        this.flag ^= 1;
        return responce;
    }

    private byte[] _sendCommand(int ctl, byte[] data, int timeout, int attemptsNumber) throws IOException {
        IOException lastEx = null;
        for (int i = 0; i < attemptsNumber; ++i) {
            try {
                return this.sendData(ctl, data, timeout);
            }
            catch (NAKException ex) {
                throw ex;
            }
            catch (IOException ex) {
                lastEx = ex;
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c", (Throwable)ex);
                if (i + 1 >= attemptsNumber) continue;
                try {
                    Random rnd = new Random();
                    int r = rnd.nextInt(this.attemptsTimeout);
                    this.log.info((Object)("Sleep " + r + " msec"));
                    Thread.sleep(r);
                    this.port.flush(Flush.RxTx);
                }
                catch (InterruptedException ex1) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!", lastEx);
    }

    private byte[] sendData(int ctl, byte[] data, int timeout) throws IOException {
        byte[] request = this.formMessage(ctl, data);
        this.port.setTimeout(200);
        this.log.debug((Object)(">>" + ByteUtils.toString(request)));
        this.port.write(request);
        this.port.setTimeout(timeout);
        int k = 0;
        int b = 0;
        do {
            if (++k <= 20) continue;
            throw new IOException("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        } while ((b = this.port.readByte()) != 2);
        int len = this.port.readByte();
        if (len < 2 || len > 250) {
            throw new IOException("Wrong answer len: " + len);
        }
        byte[] rdata = this.port.read(len - 2);
        byte[] response = new byte[len];
        response[0] = 2;
        response[1] = (byte)len;
        System.arraycopy(rdata, 0, response, 2, rdata.length);
        this.log.debug((Object)("<<" + ByteUtils.toString(response)));
        if (response[response.length - 2] != 3) {
            throw new IOException("\u0412 \u043e\u0442\u0432\u0435\u0442\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d ETX");
        }
        if (response[response.length - 1] != this.getCrc(response)) {
            throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        if ((response[2] & 1) != (request[2] & 1)) {
            throw new NAKException(rdata);
        }
        if ((response[2] & 0xE) != 0) {
            throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 DeviceType");
        }
        if (Arrays.equals(request, response) && !(request[0] == 2 && request[1] == 6 && (request[2] & 0xF0) == 80)) {
            throw new IOException("\u0420\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u043d\u043e echo");
        }
        byte[] res = new byte[rdata.length - 2];
        System.arraycopy(rdata, 0, res, 0, res.length);
        return res;
    }

    private byte[] formMessage(int ctl, byte[] data) {
        byte[] res = new byte[data == null ? 0 : data.length + 5];
        res[0] = 2;
        res[1] = (byte)res.length;
        res[2] = (byte)ctl;
        if (data != null) {
            System.arraycopy(data, 0, res, 3, data.length);
        }
        res[res.length - 2] = 3;
        res[res.length - 1] = this.getCrc(res);
        return res;
    }

    private byte getCrc(byte[] res) {
        byte crc = 0;
        for (int i = 1; i < res.length - 2; ++i) {
            crc = (byte)(crc ^ res[i] & 0xFF);
        }
        return crc;
    }

    class NAKException
    extends IOException {
        private final byte[] reply;

        public NAKException(byte[] reply) {
            this.reply = reply;
        }

        public byte[] getReply() {
            return this.reply;
        }
    }
}

