/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ebds;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.ValidatorUpdateTask;
import ru.softlogic.hardware.device.cashin.validator.ebds.BlockSearcher;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsApi;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsStatus;
import ru.softlogic.hardware.device.cashin.validator.ebds.FastBlockSearcher;
import ru.softlogic.hardware.device.cashin.validator.ebds.Note;
import ru.softlogic.hardware.device.cashin.validator.ebds.SlowBlockSearcher;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class Driver
extends Validator {
    private EbdsApi api;
    private DeviceInfo info;
    private SerialPort port;
    private String currency;
    private static final String APP = "app";
    private static final String BILLSET = "billset";

    public Driver(SerialPort port, String currency) {
        super("cashin");
        if (port == null) {
            throw new IllegalArgumentException("port");
        }
        if (currency == null) {
            throw new IllegalArgumentException("currency");
        }
        this.port = port;
        this.currency = currency;
        this.api = new EbdsApi(port);
        this.info = new DeviceInfo(DeviceType.Ebds);
        this.info.setVendor("Mei");
        this.info.setPort(port.getName());
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start");
        this.log.info((Object)("Port: " + this.port.getName()));
        this.log.info((Object)("Params: " + this.port.getParams()));
        this.log.info((Object)("Driver: " + this.info.getDeviceType()));
        this.log.info((Object)("Currency: " + this.currency));
        try {
            UpdateFile updf = null;
            EbdsStatus lastStatus = null;
            boolean canStake = false;
            this.api.open();
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(100L);
                try {
                    CashUnit bill;
                    if (this.enable) {
                        this.api.enable();
                    } else {
                        this.api.disable();
                    }
                    EbdsStatus status = this.api.poll();
                    if (!status.equals(lastStatus)) {
                        this.api.debugData(status.getData());
                    }
                    if (this.updateTask == null && status.isFlashDownload()) {
                        this.updateTask = new LocalValidatorUpdateTask(new File(PathUtils.getFirmwaresPath()), new LocalUpdateFirmwareListener());
                    }
                    if (this.updateTask != null) {
                        this.notifyStatus(ValidatorStatus.Servicing);
                        this.updateTask.update();
                        this.updateTask = null;
                        lastStatus = null;
                        updf = null;
                        continue;
                    }
                    if (lastStatus == null) {
                        Note n;
                        String updateInfo;
                        lastStatus = EbdsStatus.EMPTY;
                        this.log.info((Object)"Reset");
                        this.api.reset();
                        ThreadUtil.sleep((long)5000L);
                        for (int att = 0; att < 10; ++att) {
                            try {
                                this.log.info((Object)("Reset count: " + this.api.queryDeviceResets()));
                                break;
                            }
                            catch (IOException ex) {
                                ThreadUtil.sleep((long)1000L);
                                if (att != 9) continue;
                                throw ex;
                            }
                        }
                        this.log.info((Object)"Success reset");
                        this.api.returnCash();
                        this.api.unsetCashPolicy();
                        status = this.api.poll();
                        this.log.info((Object)"------------------------------------------------------------------------");
                        this.log.info((Object)"Bill validator info:");
                        String type = this.api.getAccessorType();
                        this.log.info((Object)("Model: " + type));
                        this.info.setModel(type);
                        String serial = this.api.getAccessorSerialNumber();
                        this.log.info((Object)("Serial: " + serial));
                        this.info.setSerial(serial);
                        this.log.info((Object)("Variant: " + this.api.getAccessorVariant()));
                        this.log.info((Object)("Variant ID: " + this.api.getAccessorVariantId()));
                        this.log.info((Object)("Application part number: " + this.api.getAccessorApplicationPartNumber()));
                        this.log.info((Object)("Application ID: " + this.api.getAccessorApplicationId()));
                        this.info.setFirmware(this.api.getAccessorVariant());
                        this.info.setFirmware1(this.api.getAccessorApplicationPartNumber() + "/" + this.api.getAccessorApplicationId());
                        this.info.setFirmware2(this.api.getAccessorVariantPart() + "/" + this.api.getAccessorVariantId());
                        if (updf == null) {
                            updf = new UpdateFile(type);
                        }
                        if ((updateInfo = updf.getVersionInfo()) != null) {
                            this.info.setUpdateInfo(updateInfo);
                            this.info.setHasUpdate(true);
                        } else {
                            this.info.setUpdateInfo("");
                            this.info.setHasUpdate(false);
                        }
                        this.log.info((Object)"Note description: ");
                        for (int i = 1; i <= 50 && (n = this.api.getNoteDescription(i)) != null; ++i) {
                            this.log.info((Object)("    " + n));
                        }
                        this.log.info((Object)"---");
                        this.notifyStatus(ValidatorStatus.Init);
                    }
                    if (status.isAccepting() && !lastStatus.isAccepting()) {
                        this.log.info((Object)"Accepting");
                        this.api.unsetCashPolicy();
                        this.notifyEvent(Event.Insert);
                        this.mutex.lock();
                    }
                    if (status.isEscrowed() && !lastStatus.isEscrowed()) {
                        this.mutex.lockNoWait();
                        this.log.info((Object)"Escrow position");
                        if (this.cashStorage != null) {
                            bill = this.getCashByNote(status);
                            if (bill != null && this.cashStorage.cashPermit(bill)) {
                                this.log.info((Object)"\u0423\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u044e \u043a\u0443\u043f\u044e\u0440\u0443");
                                canStake = true;
                                this.api.stackCash();
                            } else {
                                this.log.info((Object)"\u041f\u0440\u0438\u0435\u043c \u043a\u0443\u043f\u044e\u0440\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d");
                                this.api.returnCash();
                                this.mutex.unlock();
                            }
                        } else {
                            this.log.error((Object)"CashStorage is null, Stack cash is not permit");
                            this.api.returnCash();
                            this.mutex.unlock();
                        }
                    }
                    if (status.isStacking() && !lastStatus.isStacking()) {
                        this.log.info((Object)"Stacking");
                    }
                    if (status.isStacked() && !lastStatus.isStacked()) {
                        this.log.info((Object)"Stacked");
                        this.notifyStatus(ValidatorStatus.Ok);
                        if (canStake) {
                            if (this.cashStorage != null) {
                                bill = this.getCashByNote(status);
                                if (bill != null) {
                                    this.cashStorage.addCash(bill);
                                    this.notifyCash(bill);
                                    this.log.info((Object)("Bill stacked " + bill));
                                    canStake = false;
                                } else {
                                    this.log.error((Object)("Get unknown bill id=" + status.getBillCode() + ". Can't add bill"));
                                }
                            } else {
                                this.log.error((Object)"CashStorage is null, Can't add bill");
                            }
                        } else {
                            this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                        }
                        this.api.unsetCashPolicy();
                        this.mutex.unlock();
                    }
                    if (status.isIdling() && !lastStatus.isIdling() && !status.isStacking() && !status.isStacked()) {
                        this.log.info((Object)"Idling");
                        this.mutex.unlock();
                        this.notifyStatus(ValidatorStatus.Ok);
                    }
                    if (status.isReturning() && !lastStatus.isReturning()) {
                        this.log.info((Object)"Returning");
                        this.mutex.unlock();
                    }
                    if (status.isReturned() && !lastStatus.isReturned()) {
                        this.log.info((Object)"Returned");
                        this.api.unsetCashPolicy();
                        this.mutex.unlock();
                    }
                    if (status.isCheated() && !lastStatus.isCheated()) {
                        this.log.info((Object)"Cheated");
                    }
                    if (status.isRejected() && !lastStatus.isRejected()) {
                        this.log.info((Object)"Rejected");
                        this.notifyEvent(Event.CommonReject);
                        this.mutex.unlock();
                    }
                    if (status.isJammed() && !lastStatus.isJammed()) {
                        this.log.info((Object)"Jammed");
                        this.notifyStatus(ValidatorStatus.JammInHead);
                        this.mutex.unlock();
                    }
                    if (status.isStackerFull() && !lastStatus.isStackerFull()) {
                        this.log.info((Object)"StackerFull");
                        this.notifyStatus(ValidatorStatus.StackOverflow);
                        this.mutex.unlock();
                    }
                    if (!status.isCassetteAttached() && lastStatus.isCassetteAttached()) {
                        this.log.info((Object)"Stack out");
                        this.notifyStatus(ValidatorStatus.StackOut);
                    }
                    if (status.isPaused() && !lastStatus.isPaused()) {
                        this.log.info((Object)"Paused");
                    }
                    if (status.isCalibration() && !lastStatus.isCalibration()) {
                        this.log.info((Object)"Calibration");
                    }
                    if (status.isPowerUp() && !lastStatus.isPowerUp()) {
                        this.log.info((Object)"Power Up");
                    }
                    if (status.isInvalidCommand() && !lastStatus.isInvalidCommand()) {
                        this.log.info((Object)"Invalid Command");
                        this.mutex.unlock();
                    }
                    if (status.isFailure() && !lastStatus.isFailure()) {
                        this.log.info((Object)"Failure");
                        this.mutex.unlock();
                    }
                    lastStatus = status;
                }
                catch (IOException ex) {
                    this.mutex.unlock();
                    this.log.error((Object)ex, (Throwable)ex);
                    this.notifyStatus(ValidatorStatus.ConnectionError);
                }
            }
        }
        catch (IOException ex) {
            this.notifyStatus(ValidatorStatus.ConnectionError);
            this.log.error((Object)ex, (Throwable)ex);
        }
        catch (InterruptedException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        finally {
            this.api.close();
        }
        this.log.info((Object)"Stop thread");
    }

    public String toString() {
        return "Ebds " + this.info;
    }

    private CashUnit getCashByNote(EbdsStatus status) {
        if (status.getExtendedData() == null) {
            this.log.error((Object)"ExtData is null");
            return null;
        }
        Note n = this.api.createNote(status.getExtendedData());
        this.log.info((Object)("Note=" + n));
        if (this.currency.equals(n.getIsoCode()) || "RUB".equals(this.currency) && "RUR".equals(n.getIsoCode())) {
            CashFactory f = CashFactory.getInstance((String)n.getIsoCode());
            if (f == null) {
                return null;
            }
            CashUnit cu = f.getCashUnitByNominal(new Sum((double)n.getBase() * Math.pow(10.0, n.getExponent())));
            this.log.info((Object)("CashUnit=" + cu));
            return cu;
        }
        this.log.error((Object)"Multicurrency is not supported");
        return null;
    }

    @Override
    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
        if (this.updateTask == null) {
            this.log.info((Object)"Create task for update");
            this.updateTask = new LocalValidatorUpdateTask(updateFolder, listener);
        }
    }

    class UpdateFile {
        private final LocalValidatorUpdateTask updt;
        private final String type;

        public UpdateFile(String type) {
            this.type = type;
            this.updt = new LocalValidatorUpdateTask(new File(PathUtils.getFirmwaresPath()), new LocalUpdateFirmwareListener());
        }

        public String getVersionInfo() {
            File updFileApp = null;
            File updFileBillSet = null;
            try {
                Driver.this.log.info((Object)("Try to find app. Type: " + this.type));
                updFileApp = this.updt.getFirmwareFile(this.type, Driver.APP);
            }
            catch (Exception ex) {
                Driver.this.log.info((Object)"App file not found");
            }
            try {
                Driver.this.log.info((Object)("Try to find billset. Type: " + this.type));
                updFileBillSet = this.updt.getFirmwareFile(this.type, Driver.BILLSET);
            }
            catch (Exception ex) {
                Driver.this.log.info((Object)"Billset file not found");
            }
            if (updFileApp == null && updFileBillSet == null) {
                return null;
            }
            String updFileStr = "";
            if (updFileApp != null) {
                updFileStr = updFileStr + "App: " + this.updt.getPostfix(updFileApp);
            }
            if (updFileBillSet != null) {
                updFileStr = updFileStr + " BillSet: " + this.updt.getPostfix(updFileBillSet);
            }
            return updFileStr;
        }
    }

    class LocalUpdateFirmwareListener
    implements UpdateFirmwareListener {
        public void onResut(String string) {
            Driver.this.log.info((Object)"");
        }

        public void onError(String string) {
            Driver.this.log.info((Object)"");
        }
    }

    private class LocalValidatorUpdateTask
    implements ValidatorUpdateTask {
        private static final int BLOCK_LENGTH = 32;
        private final UpdateFirmwareListener listener;
        private final File updateFolder;

        public LocalValidatorUpdateTask(File updateFolder, UpdateFirmwareListener listener) {
            this.listener = listener;
            this.updateFolder = updateFolder;
        }

        private File getFirmwareFile(String type) throws Exception {
            File firmwareFile;
            if (type.matches("sc(l|m|xl|)?83.*")) {
                firmwareFile = new File(this.updateFolder, "mei-sc83");
            } else if (type.matches("scn(l|m|xl|)?83.*")) {
                firmwareFile = new File(this.updateFolder, "mei-scn83");
            } else {
                throw new Exception("Unknown device type: " + type);
            }
            if (!firmwareFile.exists()) {
                throw new FileNotFoundException(firmwareFile.getAbsolutePath() + " not found");
            }
            return firmwareFile;
        }

        private int getPostfix(File firmwareFile) {
            return Integer.parseInt(firmwareFile.getName().substring(firmwareFile.getName().length() - 3));
        }

        private int getPostfix(String version) {
            return Integer.parseInt(version.substring(version.length() - 3));
        }

        private File getFirmwareFile(String type, String firmwareType) throws Exception {
            File firmwareFile;
            File[] files;
            String modelNamePrefix;
            String number = null;
            String variant = null;
            if (type.toLowerCase().matches("sc(l|m|xl|)?83.*")) {
                modelNamePrefix = "mei-sc83";
            } else if (type.toLowerCase().matches("scn(l|m|xl|)?83.*")) {
                modelNamePrefix = "mei-scn83";
            } else {
                throw new Exception("Unknown device type: " + type);
            }
            if (firmwareType.equals(Driver.APP)) {
                number = Driver.this.api.getAccessorApplicationPartNumber();
            }
            if (firmwareType.equals(Driver.BILLSET)) {
                number = Driver.this.api.getAccessorVariantPart();
                variant = Driver.this.api.getAccessorVariant();
            }
            if ((files = this.updateFolder.listFiles(new FirmwareFileNameFilter(modelNamePrefix + "-" + firmwareType + ((firmwareType == null ? Driver.BILLSET == null : firmwareType.equals(Driver.BILLSET)) ? "-" + variant.toLowerCase() : "")))).length > 0) {
                firmwareFile = files[0];
                for (int i = 1; i < files.length; ++i) {
                    if (this.getPostfix(files[i]) <= this.getPostfix(firmwareFile)) continue;
                    firmwareFile = files[i];
                }
                if (number == null) {
                    throw new Exception("Cant determine accessor part number");
                }
                if (this.getPostfix(firmwareFile) <= this.getPostfix(number)) {
                    throw new UpToDateVersionException("current " + firmwareType + " v." + this.getPostfix(number) + " is up to date. File v." + this.getPostfix(firmwareFile));
                }
            } else {
                throw new FileNotFoundException(firmwareType + " file not found");
            }
            return firmwareFile;
        }

        @Override
        public void update() {
            boolean firmwarenotfound = false;
            boolean cashnotfound = false;
            try {
                try {
                    this.updateConcrete(Driver.APP);
                }
                catch (FileNotFoundException ex) {
                    firmwarenotfound = true;
                }
                try {
                    this.updateConcrete(Driver.BILLSET);
                }
                catch (FileNotFoundException ex) {
                    cashnotfound = true;
                }
                if (firmwarenotfound && cashnotfound) {
                    try {
                        this.updateConcrete("");
                    }
                    catch (FileNotFoundException ex) {}
                }
            }
            catch (Exception ex) {
                Driver.this.log.error((Object)"Updating interrupted");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateConcrete(String firmwareType) throws Exception {
            long t = System.currentTimeMillis();
            String iddevice = "<unknown device>";
            RandomAccessFile raf = null;
            File firmwareFileCopy = new File(this.updateFolder, "mei-tmp-" + firmwareType);
            try {
                BlockSearcher bs;
                int blockNumber;
                EbdsStatus status = Driver.this.api.poll();
                if (status.isFlashDownload()) {
                    Driver.this.log.info((Object)("Restore updating " + firmwareType));
                    if (!firmwareFileCopy.exists()) {
                        Driver.this.log.error((Object)("The file to restore " + firmwareType + " does not exist in " + this.updateFolder.getAbsolutePath()));
                        ThreadUtil.sleep((long)15000L);
                        return;
                    }
                    byte[] extendedData = status.getExtendedData();
                    blockNumber = (extendedData[0] << 12 | extendedData[1] << 8 | extendedData[2] << 4 | extendedData[3]) & 0xFFFF;
                    ++blockNumber;
                    raf = new RandomAccessFile(firmwareFileCopy, "r");
                    Driver.this.log.info((Object)("Download firmware from file: " + firmwareFileCopy.getAbsolutePath()));
                    if (raf.length() % 32L != 0L) {
                        throw new Exception("Data size is not a multiple of 32");
                    }
                } else {
                    blockNumber = 0;
                    String type = Driver.this.api.getAccessorType();
                    if (type == null) {
                        throw new Exception("Unknown device type: null");
                    }
                    type = type.toLowerCase();
                    iddevice = type + " " + Driver.this.api.getValidatorInfo().getFirmware().toLowerCase();
                    File firmwareFile = "".equals(firmwareType) ? this.getFirmwareFile(type) : this.getFirmwareFile(type, firmwareType);
                    Driver.this.log.info((Object)("Download firmware from file: " + firmwareFile.getAbsolutePath()));
                    FileUtils.copyFile((File)firmwareFile, (File)firmwareFileCopy);
                    raf = new RandomAccessFile(firmwareFile, "r");
                    if (raf.length() % 32L != 0L) {
                        throw new Exception("Data size is not a multiple of 32");
                    }
                    Driver.this.api.startDownloadFirmware();
                }
                Driver.this.log.info((Object)"Trying to set max boud rate");
                SerialParams sp = Driver.this.api.setMaxBaudRate();
                SerialParams oldSerialParams = Driver.this.port.getParams();
                if (sp != null) {
                    Driver.this.port.close();
                    Driver.this.port.putParams(sp);
                    Driver.this.port.open();
                    bs = new FastBlockSearcher(Driver.this.api, Driver.this.log);
                    Driver.this.log.info((Object)"Fast download mode enabled");
                } else {
                    bs = new SlowBlockSearcher(Driver.this.api, Driver.this.log);
                    Driver.this.log.info((Object)"Can't to set max boud rate, use slow download mode");
                }
                bs.setFile(raf);
                int countBlocks = bs.getBlockCount();
                int countErrors = 0;
                Driver.this.log.info((Object)("countBlocks: " + countBlocks));
                Driver.this.log.info((Object)("blockNumber: " + blockNumber));
                if (blockNumber > countBlocks) {
                    blockNumber = 0;
                }
                try {
                    ThreadUtil.sleep((long)50L);
                    while (blockNumber < countBlocks) {
                        if ((blockNumber = bs.downloadBlock(blockNumber)) < 0) {
                            if (++countErrors >= 10) {
                                Driver.this.api.finishDownloadFirmware();
                                throw new Exception("Device sends more than 10 consecutive errors");
                            }
                            blockNumber = -blockNumber - 1;
                        } else {
                            countErrors = 0;
                        }
                        Driver.this.log.info((Object)("Loaded " + blockNumber + "/" + countBlocks));
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    Driver.this.log.info((Object)"Resetting serial params");
                    Driver.this.port.close();
                    Driver.this.port.putParams(oldSerialParams);
                    Driver.this.port.open();
                }
                Driver.this.log.info((Object)"sleep 20s...");
                ThreadUtil.sleep((long)20000L);
                while (Driver.this.api.poll().isFlashDownload()) {
                    Driver.this.log.info((Object)"sleep 1s...");
                    ThreadUtil.sleep((long)1000L);
                }
                String message = "updating time: " + (System.currentTimeMillis() - t) / 1000L + " sec";
                Driver.this.log.info((Object)message);
                this.listener.onResut(iddevice + ": " + message);
                if (firmwareFileCopy.exists()) {
                    raf.close();
                    FileUtils.deleteQuietly((File)firmwareFileCopy);
                }
                Driver.this.api.finishDownloadFirmware();
                return;
            }
            catch (FileNotFoundException ex) {
                Driver.this.log.error((Object)(iddevice + ": " + ex.getMessage()));
                this.listener.onError(iddevice + ": " + ex.getMessage());
                throw ex;
            }
            catch (UpToDateVersionException ex) {
                Driver.this.log.info((Object)(iddevice + ": "), (Throwable)ex);
                this.listener.onResut(iddevice + ": " + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                Driver.this.log.error((Object)(iddevice + ": "), (Throwable)ex);
                this.listener.onError(iddevice + ": " + ex.getMessage());
                throw ex;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }

        private class FirmwareFileNameFilter
        implements FilenameFilter {
            private final String prefix;

            public FirmwareFileNameFilter(String namePrefix) {
                this.prefix = namePrefix;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.prefix);
            }
        }
    }

    class UpToDateVersionException
    extends Exception {
        public UpToDateVersionException(String message) {
            super(message);
        }
    }
}

