/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ccnet;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.validator.BillTable;
import ru.softlogic.hardware.device.cashin.validator.Denomination;
import ru.softlogic.hardware.device.cashin.validator.DynamicBillTable;
import ru.softlogic.hardware.device.cashin.validator.StaticBillTable;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.ValidatorUpdateTask;
import ru.softlogic.hardware.device.cashin.validator.ccnet.BillType;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetApi;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetInfo;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetStatus;
import ru.softlogic.hardware.device.cashin.validator.ccnet.Updater;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hdw.UpdateFailureException;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends Validator {
    private final CcnetApi api;
    private final SerialPort port;
    private final DeviceInfo info;
    private int resetCount = 0;
    private boolean hasCoin;
    private boolean servicing;
    private BillTable table;
    private final Updater updater;

    public Driver(SerialPort port, String currency) {
        super("cashin");
        this.port = port;
        this.info = new DeviceInfo(DeviceType.Ccnet);
        this.info.setVendor("CashCode");
        this.info.setPort(port.getName());
        this.log.debug((Object)"Create CCnetDriver instance");
        this.api = new CcnetApi(port);
        this.log.debug((Object)"CcnetApi created succsessfully");
        this.billTableLoad(currency);
        this.log.info((Object)("\u0412\u0430\u043b\u044e\u0442\u0430 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430: " + currency));
        this.updater = new Updater(this.api, this.log);
    }

    protected final void billTableLoad(String currency) {
        try {
            if (SystemProp.isDynamicCcnetBilltable()) {
                this.log.info((Object)"Try to load dynamic bill table");
                this.table = new DynamicBillTable(currency);
            } else {
                this.log.info((Object)"Try to load static bill table");
                this.table = new StaticBillTable(currency);
            }
            this.log.info((Object)"Success");
        }
        catch (Throwable ex) {
            this.log.info((Object)"Error, try to load dynamic bill table");
            this.table = new DynamicBillTable(currency);
            this.log.info((Object)"Success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.log.info((Object)"Start");
        this.log.info((Object)("Port: " + this.port.getName()));
        this.log.info((Object)("Params: " + this.port.getParams()));
        this.log.info((Object)("Driver: " + this.info.getDeviceType()));
        try {
            boolean canStack = false;
            CcnetStatus lastStatus = null;
            this.log.debug((Object)"Try to open serial port");
            try {
                this.api.open();
                this.log.debug((Object)"\u041f\u043e\u0440\u0442 \u043e\u0442\u043a\u0440\u044b\u0442. \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u043e\u043f\u0440\u043e\u0441");
            }
            catch (IOException ex) {
                this.log.debug((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u043e\u0440\u0442");
            }
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    try {
                        Object ex;
                        if (lastStatus == null) {
                            lastStatus = this.api.poll();
                            if (lastStatus.getStatus() == 67 || lastStatus.getStatus() == 68 || lastStatus.getStatus() == 24) {
                                this.log.info((Object)"Jamm. Disable reset.");
                                if (lastStatus.getStatus() == 67) {
                                    this.notifyStatus(ValidatorStatus.JammInHead);
                                } else {
                                    this.notifyStatus(ValidatorStatus.JammInStack);
                                }
                            } else {
                                lastStatus = null;
                            }
                            if (lastStatus == null) {
                                this.log.debug((Object)"Last status is null");
                                if (this.api.isDownloadMode()) {
                                    this.emergencyUpdate();
                                } else {
                                    this.log.debug((Object)"Send reset");
                                    this.api.reset();
                                }
                                ex = this.sync;
                                synchronized (ex) {
                                    this.sync.wait(1000L);
                                }
                            }
                        }
                        ex = this.sync;
                        synchronized (ex) {
                            this.sync.wait(75L);
                        }
                        CcnetStatus currStatus = this.api.poll();
                        if (lastStatus != null && lastStatus.getStatus() == 19 && !lastStatus.equals(currStatus) || currStatus.getStatus() == 25 && lastStatus == null || this.servicing) {
                            this.log.info((Object)("Current status = " + currStatus));
                            if (currStatus.getStatus() != 67 && currStatus.getStatus() != 68) {
                                this.log.debug((Object)"Init done. Set options");
                                BillType[] billTypes = this.api.billTable();
                                this.log.info((Object)"Bill table: ");
                                HashMap<Integer, Denomination> map = new HashMap<Integer, Denomination>();
                                for (BillType bt : billTypes) {
                                    this.log.info((Object)("    " + bt.toString()));
                                    map.put(bt.getId(), new Denomination(bt.getCurrency(), bt.getNominal()));
                                }
                                this.table.setTable(map);
                                CcnetInfo ccnetInfo = this.api.identification();
                                this.log.info((Object)("Part number: " + ccnetInfo.getPartNumber()));
                                this.log.info((Object)("Serial number: " + ccnetInfo.getSerialNumber()));
                                this.info.setModel(ccnetInfo.getModel());
                                this.info.setFirmware(ccnetInfo.getFirmware());
                                this.updater.checkFirmwareUpdate(this.info);
                                this.info.setProto("CCNET");
                                this.info.setSerial(ccnetInfo.getSerialNumber());
                                this.log.debug((Object)("Part number: " + ccnetInfo.getPartNumber() + " Serial: " + ccnetInfo.getSerialNumber()));
                                if (this.servicing) {
                                    this.servicing = false;
                                    this.notifyStatus(ValidatorStatus.Ok);
                                } else {
                                    this.notifyStatus(ValidatorStatus.Init);
                                }
                            }
                        }
                        switch (currStatus.getStatus()) {
                            case 71: {
                                if (currStatus.getSubStatus() != 155) break;
                            }
                            case 25: {
                                this.resetCount = 0;
                                if (this.enable) {
                                    this.api.enable();
                                }
                                if (this.updateTask == null) break;
                                this.notifyStatus(ValidatorStatus.Servicing);
                                this.updateTask.update();
                                this.updateTask = null;
                                this.servicing = true;
                                this.notifyStatus(ValidatorStatus.Ok);
                                break;
                            }
                            case 20: {
                                this.resetCount = 0;
                                if (this.enable) break;
                                this.api.disable();
                            }
                        }
                        if (currStatus.equals(lastStatus)) continue;
                        switch (currStatus.getStatus()) {
                            case 16: 
                            case 17: 
                            case 18: {
                                this.log.info((Object)"Power up");
                                this.api.reset();
                                break;
                            }
                            case 21: {
                                this.log.info((Object)"Accepting");
                                this.notifyEvent(Event.Insert);
                                this.mutex.lock();
                                break;
                            }
                            case 23: {
                                this.log.info((Object)"Stacking");
                                break;
                            }
                            case 24: {
                                this.log.info((Object)"Returning");
                                canStack = false;
                                this.mutex.unlock();
                                break;
                            }
                            case 26: {
                                this.log.debug((Object)"Hold");
                                break;
                            }
                            case 27: {
                                this.log.info((Object)("Busy, sleep 100*" + currStatus.getSubStatus() + " ms"));
                                Thread.sleep(100L * (long)currStatus.getSubStatus());
                                break;
                            }
                            case 65: {
                                this.log.info((Object)"Stack overflow");
                                this.notifyStatus(ValidatorStatus.StackOverflow);
                                this.tryRestore();
                                this.mutex.unlock();
                                break;
                            }
                            case 66: {
                                this.log.info((Object)"Stack out");
                                this.notifyStatus(ValidatorStatus.StackOut);
                                break;
                            }
                            case 67: {
                                this.log.info((Object)"Bill jamm in head");
                                this.notifyStatus(ValidatorStatus.JammInHead);
                                this.tryRestore();
                                this.mutex.unlock();
                                break;
                            }
                            case 68: {
                                this.log.info((Object)"Bill jamm in stack");
                                this.notifyStatus(ValidatorStatus.JammInStack);
                                this.tryRestore();
                                this.mutex.unlock();
                                break;
                            }
                            case 69: {
                                this.log.info((Object)"Cheat?");
                                this.notifyEvent(Event.CommonReject);
                                break;
                            }
                            case 70: {
                                this.log.info((Object)"Pause");
                                break;
                            }
                            case 25: {
                                this.log.info((Object)"Unit disable");
                                this.mutex.unlock();
                                this.notifyStatus(ValidatorStatus.Ok);
                                break;
                            }
                            case 20: {
                                this.log.info((Object)"Idle");
                                this.mutex.unlock();
                                this.notifyStatus(ValidatorStatus.Ok);
                                break;
                            }
                            case 19: {
                                this.log.info((Object)"Init");
                                this.mutex.unlock();
                                break;
                            }
                            case 128: {
                                CashUnit bill;
                                this.log.info((Object)("Escrow position, note id: " + currStatus.getSubStatus()));
                                if (this.cashStorage != null) {
                                    bill = this.table.get(currStatus.getSubStatus());
                                    this.log.info((Object)("Bill=" + bill));
                                    if (bill != null && this.cashStorage.cashPermit(bill)) {
                                        canStack = true;
                                        this.api.stackCash();
                                        break;
                                    }
                                    this.api.returnCash();
                                    this.log.info((Object)"Stack cash is not permit");
                                    this.mutex.unlock();
                                    break;
                                }
                                this.api.returnCash();
                                this.log.error((Object)"CashStorage is null, Stack cash is not permit");
                                this.mutex.unlock();
                                break;
                            }
                            case 129: {
                                CashUnit bill = this.table.get(currStatus.getSubStatus());
                                this.log.info((Object)("Added note id=" + currStatus.getSubStatus() + ", " + bill));
                                if (!this.hasCoin && bill.getType() == 4) {
                                    this.hasCoin = true;
                                }
                                if (bill != null && (canStack || bill.getType() == 4)) {
                                    if (this.cashStorage != null) {
                                        this.log.info((Object)"Notify cash storage");
                                        this.cashStorage.addCash(bill);
                                        this.notifyCash(bill);
                                        this.log.info((Object)("Bill stacked " + bill));
                                        canStack = false;
                                    } else {
                                        this.log.error((Object)"CashStorage is null, Can't add bill");
                                    }
                                } else {
                                    this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                                }
                                this.mutex.unlock();
                                break;
                            }
                            case 130: {
                                this.log.debug((Object)"Bill returned");
                                this.mutex.unlock();
                                break;
                            }
                            case 28: {
                                switch (currStatus.getSubStatus()) {
                                    case 96: {
                                        this.log.info((Object)"Reject: insert error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 97: {
                                        this.log.info((Object)"Reject: dielectric error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 98: {
                                        this.log.info((Object)"Reject: previos bill in head");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 99: {
                                        this.log.info((Object)"Reject: multiple factor error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 100: {
                                        this.log.info((Object)"Reject: transport error");
                                        this.notifyEvent(Event.TransportErrorReject);
                                        break;
                                    }
                                    case 101: {
                                        this.log.info((Object)"Reject: identification error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 102: {
                                        this.log.info((Object)"Reject: verification error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 103: {
                                        this.log.info((Object)"Reject: optic error");
                                        this.notifyEvent(Event.OpticErrorReject);
                                        break;
                                    }
                                    case 104: {
                                        this.log.debug((Object)"Reject: inhibit error");
                                        break;
                                    }
                                    case 106: {
                                        this.log.info((Object)"Reject: operation error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 108: {
                                        this.log.debug((Object)"Reject: length error");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 109: {
                                        this.log.info((Object)"Reject: UV");
                                        this.notifyEvent(Event.CommonReject);
                                        break;
                                    }
                                    case 146: 
                                    case 147: 
                                    case 148: 
                                    case 149: {
                                        this.log.debug((Object)"Reject: barcode");
                                        this.notifyEvent(Event.CommonReject);
                                    }
                                }
                                this.log.debug((Object)"\u043e\u0442\u043a\u0430\u0437");
                                this.mutex.unlock();
                                break;
                            }
                            case 71: {
                                switch (currStatus.getSubStatus()) {
                                    case 80: {
                                        this.log.info((Object)"Fail: stack motor");
                                        this.notifyStatus(ValidatorStatus.StackMotorError);
                                        break;
                                    }
                                    case 81: 
                                    case 82: {
                                        this.log.info((Object)"Fail: transport motor");
                                        this.notifyStatus(ValidatorStatus.TransportMotorError);
                                        break;
                                    }
                                    case 83: {
                                        this.log.info((Object)"Fail: align motor");
                                        this.notifyStatus(ValidatorStatus.AlignMotorError);
                                        break;
                                    }
                                    case 84: {
                                        this.log.info((Object)"Fail: init stack");
                                        this.notifyStatus(ValidatorStatus.InitStackError);
                                        break;
                                    }
                                    case 85: {
                                        this.log.info((Object)"Fail: optic canal");
                                        this.notifyStatus(ValidatorStatus.OpticCanalError);
                                        break;
                                    }
                                    case 86: {
                                        this.log.info((Object)"Fail: magnetic canal");
                                        this.notifyStatus(ValidatorStatus.MagneticCanalError);
                                        break;
                                    }
                                    case 95: {
                                        this.log.info((Object)"Fail: capacitance canal");
                                        this.notifyStatus(ValidatorStatus.CapacitanceCanalError);
                                        break;
                                    }
                                    case 155: {
                                        this.log.info((Object)"Smartstick failure");
                                    }
                                }
                                this.mutex.unlock();
                                break;
                            }
                            default: {
                                this.log.debug((Object)String.format("\u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0441 \u043a\u043e\u0434\u043e\u043c 0x%02x", currStatus.getStatus()));
                            }
                        }
                        lastStatus = currStatus;
                    }
                    catch (InterruptedException ex) {
                        this.mutex.unlock();
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException ex) {
                        this.mutex.unlock();
                        this.log.error((Object)ex, (Throwable)ex);
                        lastStatus = null;
                        this.notifyStatus(ValidatorStatus.ConnectionError);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return;
                }
            }
        }
        finally {
            this.log.debug((Object)"Stop thread");
            this.api.close();
        }
    }

    @Override
    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
        if (this.updateTask == null) {
            this.log.info((Object)"Create task for update");
            this.updateTask = new LocalValidatorUpdateTask(listener);
        }
    }

    public String toString() {
        return "CcnetDriver " + this.info;
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private void tryRestore() throws IOException {
        ++this.resetCount;
        if (this.resetCount < 5) {
            this.log.info((Object)"Try reset device");
            this.api.reset();
        }
    }

    public int getExtraTimeout() {
        return this.hasCoin ? 600 : 0;
    }

    private void emergencyUpdate() throws IOException, InterruptedException {
        this.log.info((Object)"Device in downloading mode");
        try {
            this.updater.onlyLoad();
        }
        catch (UpdateFailureException ex) {
            this.log.error((Object)"Error on load firmware", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
    }

    private class LocalValidatorUpdateTask
    implements ValidatorUpdateTask {
        private final UpdateFirmwareListener listener;

        public LocalValidatorUpdateTask(UpdateFirmwareListener listener) {
            this.listener = listener;
        }

        @Override
        public void update() {
            long t = System.currentTimeMillis();
            String idDev = "<unknown device>";
            try {
                idDev = "ccnet " + Driver.this.api.getValidatorInfo().getFirmware().substring(0, 2).toLowerCase();
                Driver.this.updater.update();
                this.listener.onResut(idDev + ": updating tume: " + (System.currentTimeMillis() - t) / 1000L + " sec");
            }
            catch (IOException ex) {
                Driver.this.log.error((Object)ex, (Throwable)ex);
                this.listener.onError(idDev + ": " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                Driver.this.log.error((Object)ex, (Throwable)ex);
                this.listener.onError(idDev + ": " + ex.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (UpdateFailureException ex) {
                Driver.this.log.info((Object)"Smart card isn't found. Don't create task for update");
                this.listener.onError("Smart card isn't found");
            }
        }
    }
}

