/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator.ccnet;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.cashin.validator.ccnet.WrongCommandException;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class CcnetConnection {
    public static final byte CMD_POLL = 51;
    public static final byte CMD_RESET = 48;
    public static final byte CMD_STATUS = 49;
    public static final byte CMD_SECURE = 50;
    public static final byte CMD_ENABLE = 52;
    public static final byte CMD_DISABLE = 52;
    public static final byte CMD_STACK = 53;
    public static final byte CMD_RETURN = 54;
    public static final byte CMD_IDENTIFICATION = 55;
    public static final byte CMD_BILLTABLE = 65;
    public static final byte CMD_UPDATE_MODE = 80;
    private static final int MAX_LEN = 20;
    private SerialPort port;
    private int attempts = 5;
    private int attemptsTimeout = 3000;
    private int ioTimeout = 1500;
    private final Logger log = Logger.getLogger((String)"cashin");

    public CcnetConnection(SerialPort port) {
        this.log.setAdditivity(false);
        if (port == null) {
            throw new IllegalArgumentException("\u041f\u043e\u0440\u0442 \u043d\u0443\u0436\u0435\u043d");
        }
        port.close();
        this.port = port;
    }

    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
        this.port.setRTS(false);
        this.port.setDTR(false);
    }

    public void close() {
        this.port.close();
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getAttemptsTimeout() {
        return this.attemptsTimeout;
    }

    public int getIoTimeout() {
        return this.ioTimeout;
    }

    public void setIoTimeout(int ioTimeout) {
        this.ioTimeout = ioTimeout;
    }

    public void setAttemptsTimeout(int attemptsTimeout) {
        this.attemptsTimeout = attemptsTimeout;
    }

    public final byte[] sendCommand(byte cmd) throws IOException {
        return this.sendCommand(cmd, null, true);
    }

    public final byte[] sendCommand(byte cmd, byte[] data) throws IOException {
        return this.sendCommand(cmd, data, true);
    }

    public final byte[] sendCommand(byte cmd, byte[] data, boolean sendAns) throws IOException {
        try {
            return this.sendCommandEx(cmd, data, sendAns);
        }
        catch (WrongCommandException ex) {
            throw new IOException(ex);
        }
    }

    public final byte[] sendCommandEx(byte cmd, byte[] data, boolean sendAns) throws IOException, WrongCommandException {
        IOException lastEx = null;
        byte[] request = this.formMessage(cmd, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                byte[] rdata;
                this.port.setTimeout(this.ioTimeout);
                this.port.write(request);
                int k = 0;
                do {
                    rdata = this.port.read(1);
                    if (++k <= 20) continue;
                    throw new IOException("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                } while (rdata[0] != 2);
                byte sync = rdata[0];
                this.port.setTimeout(100);
                rdata = this.port.read(1);
                byte address = rdata[0];
                rdata = this.port.read(1);
                int len = BU.c((byte)rdata[0]);
                if (len < 4) {
                    throw new IOException("Wrong answer len=" + len);
                }
                this.port.setTimeout(2000 + len * 125);
                rdata = this.port.read(len - 3);
                byte[] response = new byte[len];
                response[0] = sync;
                response[1] = address;
                response[2] = BU.c((int)len);
                System.arraycopy(rdata, 0, response, 3, len - 3);
                if (!this.checkCrc16(response)) {
                    Thread.sleep(20L);
                    if (sendAns) {
                        this.port.write(this.formMessage((byte)-1, null));
                    }
                    throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0432\u0445\u043e\u0434\u044f\u0448\u0435\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u043b\u0430");
                }
                if (response.length == 6 && (response[3] & 0xFF) == 255) {
                    throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u043b\u0430");
                }
                if (response.length == 6 && (response[3] & 0xFF) == 48) {
                    throw new WrongCommandException();
                }
                if (sendAns) {
                    this.port.write(this.formMessage((byte)0, null));
                }
                byte[] result = new byte[response.length - 5];
                for (int z = 0; z < response.length - 5; ++z) {
                    result[z] = response[z + 3];
                }
                return result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
            catch (IOException e) {
                lastEx = e;
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c", (Throwable)e);
                if (i + 1 >= this.attempts) continue;
                try {
                    Random rnd = new Random();
                    int r = rnd.nextInt(this.attemptsTimeout);
                    this.log.info((Object)("Sleep " + r + " msec"));
                    Thread.sleep(r);
                    this.port.close();
                    this.port.open();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!", lastEx);
    }

    private byte[] formMessage(byte cmd, byte[] data) {
        int dataLen = 6;
        boolean flag = false;
        if (data != null) {
            flag = data.length >= 64;
            dataLen += data.length;
        }
        byte[] request = new byte[dataLen];
        request[0] = 2;
        request[1] = 3;
        request[2] = flag ? (byte)0 : (byte)dataLen;
        request[3] = cmd;
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                request[4 + i] = data[i];
            }
        }
        this.signCrc16(request);
        return request;
    }

    private void signCrc16(byte[] data) {
        if (data.length < 2) {
            return;
        }
        int crc = this.makeCrc16(data);
        data[data.length - 2] = (byte)(crc & 0xFF);
        data[data.length - 1] = (byte)(crc >> 8 & 0xFF);
    }

    private boolean checkCrc16(byte[] data) {
        if (data.length < 6) {
            return false;
        }
        int crc = this.makeCrc16(data);
        byte crc1 = (byte)(crc & 0xFF);
        byte crc2 = (byte)(crc >> 8 & 0xFF);
        return data[data.length - 2] == crc1 && data[data.length - 1] == crc2;
    }

    private int makeCrc16(byte[] data) {
        int crc = 0;
        if (data.length < 2) {
            return crc;
        }
        for (int i = 0; i < data.length - 2; ++i) {
            crc ^= 0xFF & data[i];
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) > 0) {
                    crc >>= 1;
                    crc ^= 0x8408;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }
}

