/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.validator;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.acceptor.ManagedCashAcceptor;
import ru.softlogic.cash.manager.observer.UpdateFirmwareListener;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.Device;
import ru.softlogic.hardware.device.cashin.CashObserver;
import ru.softlogic.hardware.device.cashin.validator.ValidatorUpdateTask;
import ru.softlogic.hardware.device.cashin.validator.statistics.Event;
import ru.softlogic.hardware.device.cashin.validator.statistics.StatisticListener;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.system.concurrency.Mutex;

public abstract class Validator
extends ManagedCashAcceptor
implements Device,
Runnable {
    protected Mutex mutex;
    protected volatile boolean enable;
    protected Logger log;
    protected Set<CashUnit> cashUnits;
    protected Set<CashUnit> coinUnits;
    private final Set<StatisticListener> statisticObservers;
    private final Set<ValidatorStatusListener> statusObservers;
    private final Set<CashObserver> cashObservers;
    private ValidatorStatus lastStatus;
    protected final Object sync = new Object();
    protected ValidatorUpdateTask updateTask;

    public Validator(String logName) {
        this.log = Logger.getLogger((String)(logName == null ? "cashin" : logName));
        this.log.setAdditivity(false);
        this.mutex = new Mutex();
        this.statisticObservers = new HashSet<StatisticListener>();
        this.statusObservers = new HashSet<ValidatorStatusListener>();
        this.cashObservers = new HashSet<CashObserver>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(Set<CashUnit> cashUnits, Set<CashUnit> coinUnits) {
        try {
            this.log.info((Object)"-------------------------------------------------------------------");
            this.log.info((Object)"Enable cash acceptor");
            this.mutex.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.cashUnits = cashUnits;
        this.coinUnits = coinUnits;
        this.enable = true;
        this.mutex.unlock();
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        this.log.info((Object)"Cash acceptor is enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        try {
            this.log.info((Object)"Disable cash acceptor");
            this.mutex.lock();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.enable = false;
        this.mutex.unlock();
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        this.log.info((Object)"Cash acceptor is disabled");
    }

    public final boolean addStatisticObserver(StatisticListener observer) {
        if (observer == null) {
            return false;
        }
        return this.statisticObservers.add(observer);
    }

    public final boolean addStatusObserver(ValidatorStatusListener observer) {
        if (observer == null) {
            return false;
        }
        return this.statusObservers.add(observer);
    }

    public final boolean addCashObserver(CashObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.cashObservers.add(observer);
    }

    protected final void notifyStatus(ValidatorStatus status) {
        if (!status.equals((Object)this.lastStatus)) {
            this.log.info((Object)("Notify status: " + (Object)((Object)status)));
            for (ValidatorStatusListener observer : this.statusObservers) {
                observer.update(status);
            }
            this.lastStatus = status;
        }
    }

    protected final void notifyEvent(Event event) {
        for (StatisticListener observer : this.statisticObservers) {
            observer.notify(event);
        }
    }

    protected final void notifyCash(CashUnit cu) {
        this.log.info((Object)"Notify listeners");
        for (CashObserver observer : this.cashObservers) {
            observer.notify(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(int ms) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            this.sync.wait(ms);
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setMaxSum(Sum sum) {
    }

    public void updateFirmware(File updateFolder, UpdateFirmwareListener listener) {
    }
}

