/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.nriC2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Activity;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Connection;
import ru.softlogic.hardware.device.cashin.coin.nriC2.DiagnosticStatus;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Info;
import ru.softlogic.hardware.device.cashin.coin.nriC2.NRIConnection;
import ru.softlogic.hardware.device.cashin.coin.nriC2.Status;
import ru.softlogic.hardware.device.cashin.coin.nriC2.TubeStatus;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class CurenzaApi
implements ValidatorApi {
    private final SerialPort serialPort;
    private final Connection mdbConnection;
    private final SerialParams[] sp;
    private Logger log;

    public CurenzaApi(SerialPort serialPort, Logger log) {
        if (serialPort == null) {
            throw new IllegalArgumentException("SerialPort must be not null");
        }
        if (log == null) {
            log = Logger.getLogger((String)"cashin");
        }
        this.log = log;
        this.serialPort = serialPort;
        this.mdbConnection = new Connection(serialPort, log);
        this.sp = new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public void test() throws IOException {
        this.mdbInit();
        this.reset();
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        Info inf = this.info();
        return new ValidatorInfo(inf.getCompany() + " " + inf.getModel());
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.sp) {
            try {
                this.serialPort.putParams(params);
                this.mdbConnection.open();
                if (!this.mdbConnection.init()) continue;
                this.mdbConnection.reset();
                DeviceType deviceType = this.getDeviceType();
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.mdbConnection.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.CurrenzaC2;
    }

    @Override
    public void open() throws IOException {
        this.mdbConnection.open();
    }

    public boolean mdbInit() throws IOException {
        return this.mdbConnection.init();
    }

    @Override
    public void close() {
        this.mdbConnection.close();
    }

    public final void reset() throws IOException {
        this.mdbConnection.reset();
    }

    public final void enable() throws IOException {
        int[] mask = new int[]{255, 255, 255, 255};
        this.mdbConnection.coinType(mask);
    }

    public final void disable() throws IOException {
        int[] mask = new int[]{0, 0, 0, 0};
        this.mdbConnection.coinType(mask);
    }

    public void dispense(int cointType, int number) throws IOException {
        int param = (number & 0xF) << 4 | cointType & 0xF;
        this.mdbConnection.dispence(param);
    }

    public void dispense(Activity activity) throws IOException {
        if (activity.getActivityType() != 64) {
            return;
        }
        if (activity.getCoinRouting() != 0 && activity.getCoinRouting() != 1) {
            return;
        }
        this.dispense(activity.getCoinType(), 1);
    }

    public TubeStatus tubeStatus() throws IOException {
        byte[] ret = this.mdbConnection.tubeStatus();
        int isFullTubeMask = ret[0] << 8 & ret[1];
        int[] coinCount = new int[ret.length - 2];
        for (int i = 2; i < ret.length; ++i) {
            coinCount[i - 2] = ret[i] & 0xFF;
        }
        return new TubeStatus(isFullTubeMask, coinCount);
    }

    public final List<Activity> poll() throws IOException {
        byte[] data = this.mdbConnection.poll();
        if (data == null) {
            return null;
        }
        if (Arrays.equals(data, NRIConnection.ACK)) {
            return Collections.emptyList();
        }
        ArrayList<Activity> activities = new ArrayList<Activity>();
        int i = 0;
        while (i < data.length) {
            if ((data[i] & 0xC0) != 0) {
                if (i + 1 < data.length) {
                    activities.add(new Activity(data[i], data[i + 1]));
                }
                i += 2;
                continue;
            }
            activities.add(new Activity(data[i], data[i]));
            ++i;
        }
        return activities;
    }

    public final Status setup() throws IOException {
        byte[] data = this.mdbConnection.setup();
        if (data.length < 23) {
            byte[] newData = new byte[23];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        byte featureLevel = data[0];
        String currencyCode = null;
        if ((data[1] & 0xF0) == 16) {
            currencyCode = BU.toHexString((byte[])new byte[]{(byte)(data[1] & 0xF), data[2]}).substring(1);
        }
        byte coinScalingFactor = data[3];
        byte decimalPlaces = data[4];
        int coinTypesRouting = data[5] << 8 | data[6];
        byte[] coinTypeCredit = new byte[16];
        System.arraycopy(data, 7, coinTypeCredit, 0, coinTypeCredit.length);
        return new Status(featureLevel, currencyCode, coinScalingFactor, decimalPlaces, coinTypesRouting, coinTypeCredit);
    }

    public final Info info() throws IOException {
        byte[] ret = this.mdbConnection.expansionIdentification();
        this.log.info((Object)BU.toString((byte[])ret));
        String source = new String(ret);
        String manufacturer = source.substring(0, 3);
        String serialNumber = source.substring(3, 15);
        String model = source.substring(15, 27);
        String version = BU.toHexString((byte[])new byte[]{ret[27], ret[28]});
        Info info = new Info(manufacturer, serialNumber, model, version);
        return info;
    }

    public final DiagnosticStatus diagnostic() throws IOException {
        byte[] ret = this.mdbConnection.expansionIdentification();
        return new DiagnosticStatus(ret.length > 0 ? ret[0] : (byte)0, ret.length > 1 ? ret[1] : 0);
    }
}

