/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.mei;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.mei.MDBInfo;
import ru.softlogic.hardware.device.cashin.coin.mei.NRIConnection;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.hardware.utils.BCDUtils;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class MeiMDBApi
implements ValidatorApi {
    private final SerialPort port;
    private final NRIConnection connection;
    private Logger log;

    public MeiMDBApi(SerialPort port, Logger log) {
        this.port = port;
        this.log = log;
        if (this.log == null) {
            this.log = Logger.getLogger((String)"coin");
        }
        this.connection = new NRIConnection(port, this.log);
    }

    public byte[] reset() throws IOException {
        return this.truncate(this.connection.sendCmd(8));
    }

    public byte[] setup() throws IOException {
        byte[] info = this.parceInfo(this.truncate(this.connection.sendCmd(9)));
        if (this.isValidCRC(info)) {
            return info;
        }
        return new byte[0];
    }

    public byte[] billType(byte[] mask) throws IOException {
        return this.parceInfo(this.truncate(this.connection.sendCmd(12, mask, true)));
    }

    public byte[] status() throws IOException {
        return this.parceInfo(this.truncate(this.connection.sendCmd(10, null, true, 700)));
    }

    public byte[] poll() throws IOException {
        return this.truncate(this.connection.sendCmd(11));
    }

    public byte[] readEvent() throws IOException {
        return this.parceInfo(this.truncate(this.connection.readData()));
    }

    public byte[] dispense(byte mask) throws IOException {
        return this.parceInfo(this.truncate(this.connection.sendCmd(13, new byte[]{mask}, true, 100)));
    }

    public byte[] diagnostic() throws IOException {
        return this.parceInfo(this.truncate(this.connection.sendCmd(15, new byte[]{5}, true)));
    }

    public MDBInfo info() throws IOException {
        MDBInfo info = null;
        byte[] b = this.parceInfo(this.truncate(this.connection.sendCmd(15, new byte[]{0}, true)));
        if (b != null && b.length == 34 && this.isValidCRC(b)) {
            info = new MDBInfo();
            byte[] t = new byte[3];
            System.arraycopy(b, 0, t, 0, 3);
            info.setCompany(new String(t).trim());
            t = new byte[12];
            System.arraycopy(b, 3, t, 0, 12);
            info.setSerial(new String(t).trim());
            t = new byte[12];
            System.arraycopy(b, 15, t, 0, 12);
            info.setModel(new String(t).trim());
            info.setSoftware("MDB v" + BCDUtils.bcdToAscii(b[27]) + "." + BCDUtils.bcdToAscii(b[28]));
        }
        return info;
    }

    byte[] truncate(byte[] src) {
        if (src == null) {
            return null;
        }
        if (src.length > 2 && src[src.length - 1] == 10 && src[src.length - 2] == 13 && src[src.length - 3] == 32) {
            byte[] res = new byte[src.length - 3];
            System.arraycopy(src, 0, res, 0, res.length);
            return res;
        }
        if (src.length > 1 && src[src.length - 1] == 10 && src[src.length - 2] == 13) {
            byte[] res = new byte[src.length - 2];
            System.arraycopy(src, 0, res, 0, res.length);
            return res;
        }
        return src;
    }

    private byte[] parceInfo(byte[] src) {
        if (src == null || src.length == 0) {
            return src;
        }
        this.log.debug((Object)("Parce " + ByteUtils.toString(src)));
        try {
            byte[] t = new byte[src.length / 3 + (src.length % 3 == 2 ? 1 : 0)];
            int crc = 0;
            for (int i = 0; i < t.length; ++i) {
                int p1 = Byte.parseByte("" + (char)src[i * 3], 16) << 4;
                byte p2 = Byte.parseByte("" + (char)src[i * 3 + 1], 16);
                t[i] = (byte)((p1 | p2) & 0xFF);
                crc += t[i];
            }
            return t;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return NRIConnection.EMPTY_ANSWER;
        }
    }

    private boolean isValidCRC(byte[] src) {
        if (src == null || src.length == 0) {
            return false;
        }
        byte r = 0;
        for (int i = 0; i < src.length - 1; ++i) {
            r = (byte)(r + (byte)(src[i] & 0xFF));
        }
        return r == src[src.length - 1];
    }

    @Override
    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
        this.port.setRTS(true);
        this.port.setDTR(true);
    }

    @Override
    public void close() {
        this.port.close();
    }

    @Override
    public void test() throws IOException {
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        MDBInfo info = this.info();
        StringBuilder sb = new StringBuilder();
        if (info.getCompany() != null) {
            sb.append(info.getCompany());
        }
        if (info.getModel() != null) {
            sb.append(" ").append(info.getModel());
        }
        if (info.getSerial() != null) {
            sb.append(" ").append(info.getSerial());
        }
        if (info.getSoftware() != null) {
            sb.append(" ").append(info.getSoftware());
        }
        return new ValidatorInfo(sb.toString().trim());
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.getAvailableParameters()) {
            block6: {
                this.log.info((Object)(this.port.getName() + " \u0418\u0449\u0443 MEI CF 7000 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: " + params));
                this.port.putParams(params);
                this.port.open();
                MDBInfo info = this.info();
                if (info == null) break block6;
                this.log.info((Object)(this.port.getName() + " \u041d\u0430\u0448\u043b\u0438"));
                DeviceType deviceType = null;
                this.port.close();
                return deviceType;
            }
            try {
                try {
                    throw new NoSuchDeviceException();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.log.error((Object)(this.port.getName() + " \u041d\u0435 \u043d\u0430\u0448\u043b\u0438"));
                    this.port.close();
                }
            }
            catch (Throwable throwable) {
                this.port.close();
                throw throwable;
            }
        }
        throw new NoSuchDeviceException();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.MeiCF7000;
    }
}

