/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.eu;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.eu.EU9Api;
import ru.softlogic.hardware.device.cashin.coin.eu.EventListener;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class Driver
extends Validator
implements EventListener {
    private final SerialPort port;
    private final EU9Api api;
    private final DeviceInfo info;
    private final Map<Integer, CashUnit> billTable;
    private final CashFactory cf;

    public Driver(SerialPort port, String currency) {
        super("coin");
        this.port = port;
        this.info = new DeviceInfo(DeviceType.EU9Coin);
        this.info.setPort(port.getName());
        this.info.setVendor("EU-9");
        this.info.setModel("EU-9");
        this.api = new EU9Api(port, this.log);
        this.billTable = new HashMap<Integer, CashUnit>();
        this.cf = CashFactory.getInstance((String)currency);
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.EU9Coin)));
        this.log.info((Object)("Serial params: " + this.port.getParams()));
        boolean inited = false;
        Boolean lastEnable = null;
        this.api.setListener(this);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!inited) {
                    this.getCoinInfo();
                    inited = true;
                    this.notifyStatus(ValidatorStatus.Init);
                }
                if (lastEnable == null || lastEnable != this.enable) {
                    lastEnable = this.enable;
                    if (this.enable) {
                        this.log.info((Object)"Enable coin acceptor, modify inhibit status");
                        this.processChannels();
                        this.log.info((Object)"Enable coin acceptor");
                        this.api.setEnable(true);
                        this.log.info((Object)"Success");
                    } else {
                        this.log.info((Object)"Disable coin acceptor");
                        this.processChannels();
                        this.api.setEnable(false);
                        this.log.info((Object)"Disabled, process events");
                        ThreadUtil.sleep((long)200L);
                        this.api.readEvent(0);
                        this.log.info((Object)"Done");
                    }
                }
                this.api.readEvent(0);
                ThreadUtil.sleep((long)100L);
                this.notifyStatus(ValidatorStatus.Ok);
            }
            catch (IOException ex) {
                this.log.info((Object)"I/O error", (Throwable)ex);
                inited = false;
                this.api.close();
                ThreadUtil.sleep((long)1000L);
                this.notifyStatus(ValidatorStatus.ConnectionError);
            }
        }
        this.log.info((Object)"Disable coin acceptor");
        try {
            this.api.setEnable(false);
        }
        catch (IOException ex) {
            this.log.error((Object)"Error on set disable", (Throwable)ex);
        }
        this.log.info((Object)"Stop thread");
    }

    private void getCoinInfo() throws IOException {
        try {
            this.log.info((Object)("Try to open port " + this.port.getName()));
            this.api.open();
            this.log.info((Object)"Disable channels");
            for (int i = 0; i < 12; ++i) {
                this.api.disableChannel(i);
            }
            this.log.info((Object)"Get coin description:");
            this.billTable.clear();
            this.billTable.put(0, this.cf.getCoinUnitByNominal(new Sum(100)));
            this.billTable.put(1, this.cf.getCoinUnitByNominal(new Sum(200)));
            this.billTable.put(2, this.cf.getCoinUnitByNominal(new Sum(500)));
            this.billTable.put(3, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.billTable.put(4, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.billTable.put(5, this.cf.getCoinUnitByNominal(new Sum(500)));
            this.billTable.put(6, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.billTable.put(7, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.billTable.put(8, this.cf.getCoinUnitByNominal(new Sum(500)));
            this.billTable.put(9, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.billTable.put(10, this.cf.getCoinUnitByNominal(new Sum(1000)));
            this.log.info((Object)("Coin table: " + this.billTable));
        }
        catch (IOException ex) {
            this.log.error((Object)"I/O error", (Throwable)ex);
            throw ex;
        }
    }

    private void processChannels() throws IOException {
        this.log.info((Object)"Modify channels");
        for (Integer i : this.billTable.keySet()) {
            CashUnit cu = this.billTable.get(i);
            if (this.canStack(cu)) {
                this.log.info((Object)("Enable channel: " + i));
                this.api.enableChannel(i);
                continue;
            }
            this.log.info((Object)("Disable channel: " + i));
            this.api.disableChannel(i);
        }
        this.log.info((Object)"Done");
    }

    @Override
    public void onCoin(int nominal) {
        this.log.info((Object)("Get coin: " + nominal));
        if (this.cf != null) {
            CashUnit cu = this.cf.getCoinUnitByNominal(new Sum(nominal * 100));
            this.log.info((Object)("Get coin: " + cu));
            if (cu != null) {
                this.notifyCash(cu);
                this.cashStorage.addCash(cu);
            }
        } else {
            this.log.error((Object)"Cash factory is null");
        }
    }

    boolean canStack(CashUnit cu) {
        if (this.cashStorage != null && cu != null) {
            return this.cashStorage.cashPermit(cu);
        }
        return false;
    }
}

