/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.cctalk;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.SerialPort;

public class ccTalkConnection {
    private SerialPort port;
    private Logger log;
    private int attemptCount = 3;
    private int dest;

    public ccTalkConnection(SerialPort port, int dest) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.dest = dest;
        this.log = Logger.getLogger((String)"coin");
        this.log.setAdditivity(false);
        port.setTimeout(1000);
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public byte[] sendMessage(int header) throws IOException {
        return this.sendMessage(header, null);
    }

    public byte[] sendMessage(int header, byte[] data) throws IOException {
        IOException last = null;
        byte[] request = this.getRequest(1, this.dest, header, data);
        for (int i = 0; i < this.attemptCount; ++i) {
            try {
                this.log.debug((Object)(">>" + ByteUtils.toString(request)));
                this.port.write(request);
                int res = this.port.readByte();
                if (res == 2) {
                    this.port.read(request.length - 1);
                    res = this.port.readByte();
                }
                if (res != 1) {
                    throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u0431\u0430\u0439\u0442 '1'. \u041f\u043e\u043b\u0443\u0447\u0435\u043d " + res);
                }
                int packetSize = this.port.readByte();
                byte[] oth = this.port.read(3 + packetSize);
                if (oth[1] == 5) {
                    throw new IOException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d NAK");
                }
                if (oth[1] == 6) {
                    throw new IOException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d BUSY");
                }
                if (oth[1] != 0) {
                    throw new IOException("Header \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442\u043b\u0438\u0447\u0435\u043d \u043e\u0442 \u043d\u0443\u043b\u044f. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + oth[1]);
                }
                byte[] responce = new byte[5 + packetSize];
                responce[0] = (byte)res;
                responce[1] = (byte)packetSize;
                System.arraycopy(oth, 0, responce, 2, oth.length);
                this.log.debug((Object)("<<" + ByteUtils.toString(responce)));
                byte crc = this.getCrc(responce);
                if (crc != responce[responce.length - 1]) {
                    throw new IOException("CRC is not valid");
                }
                byte[] result = new byte[packetSize];
                System.arraycopy(responce, 4, result, 0, packetSize);
                this.log.debug((Object)("<< data=" + ByteUtils.toString(result)));
                return result;
            }
            catch (IOException ex) {
                this.log.debug((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435", (Throwable)ex);
                last = ex;
                continue;
            }
        }
        throw new IOException("\u041e\u0431\u043c\u0435\u043d \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d \u0437\u0430 3 \u043f\u043e\u043f\u044b\u0442\u043a\u0438", last);
    }

    private byte[] getRequest(int srcAddress, int destAddress, int header, byte[] data) {
        byte[] request = new byte[5 + (data == null ? 0 : data.length)];
        request[0] = (byte)destAddress;
        request[1] = (byte)(data == null ? 0 : data.length);
        request[2] = (byte)srcAddress;
        request[3] = (byte)header;
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, request, 4, data.length);
        }
        request[request.length - 1] = this.getCrc(request);
        return request;
    }

    private byte getCrc(byte[] data) {
        int crc = 0;
        for (int i = 0; i < data.length - 1; ++i) {
            crc = (byte)(crc + data[i]);
        }
        return (byte)(256 - crc);
    }
}

