/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.cctalk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.cctalk.BufferedCredit;
import ru.softlogic.hardware.device.cashin.coin.cctalk.EventPair;
import ru.softlogic.hardware.device.cashin.coin.cctalk.ccTalkConnection;
import ru.softlogic.hardware.device.cashin.validator.ValidatorApi;
import ru.softlogic.hardware.device.cashin.validator.ValidatorInfo;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class ccTalkApi
implements ValidatorApi {
    private final SerialPort port;
    private final ccTalkConnection conn;
    private final Logger log;
    private final Map<Boolean, SerialParams[]> serialParams;

    public ccTalkApi(SerialPort port) {
        this.port = port;
        this.conn = new ccTalkConnection(port, 2);
        this.log = Logger.getLogger((String)"coin");
        this.log.setAdditivity(false);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttemptCount(2);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.log.info((Object)(this.port.getName() + " \u0418\u0449\u0443 CCTALK \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438: " + params));
                this.port.putParams(params);
                this.open();
                this.conn.sendMessage(254);
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception ex) {
                this.log.error((Object)(this.port.getName() + " \u041d\u0435 \u043d\u0430\u0448\u043b\u0438"));
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException();
    }

    public int requestSorterPaths(int position) throws IOException {
        byte[] res = this.conn.sendMessage(209, this.conv(position));
        this.log.info((Object)BU.toString((byte[])res));
        return BU.c((byte)res[0]);
    }

    public void modifySorterPaths(int position, int path) throws IOException {
        this.conn.sendMessage(210, this.conv(position, path));
    }

    public int requestDefaultSorterPath() throws IOException {
        byte[] res = this.conn.sendMessage(188);
        return BU.c((byte)res[0]);
    }

    public void modifyDefaultSorterPath(int path) throws IOException {
        this.conn.sendMessage(189, this.conv(path));
    }

    public void simplePoll() throws IOException {
        this.conn.sendMessage(254);
    }

    public int requestStatus() throws IOException {
        byte[] data = this.conn.sendMessage(248);
        return data[0] & 0xFF;
    }

    public String requestManufacterId() throws IOException {
        byte[] data = this.conn.sendMessage(246);
        return new String(data);
    }

    public String requestEquipmentCategoryId() throws IOException {
        byte[] data = this.conn.sendMessage(245);
        return new String(data);
    }

    public String requestProductCode() throws IOException {
        byte[] data = this.conn.sendMessage(244);
        return new String(data);
    }

    public int requestSerialNumber() throws IOException {
        byte[] data = this.conn.sendMessage(242);
        return (data[0] & 0xFF) + ((data[1] & 0xFF) + (data[2] & 0xFF) << 8) << 8;
    }

    public String requestSoftwareRevision() throws IOException {
        byte[] data = this.conn.sendMessage(241);
        return new String(data);
    }

    public String requestCountryScalingFactor(String country) throws IOException {
        if (country == null || country.length() != 2) {
            throw new IllegalArgumentException("Wrong country code, lenght must be 2");
        }
        byte[] data = this.conn.sendMessage(156, country.getBytes());
        this.log.info((Object)(">>requestCountryScalingFactor: " + BU.toHexString((byte[])data)));
        return new String(data);
    }

    public int performSelfCheck() throws IOException {
        byte[] data = this.conn.sendMessage(232);
        return data[0];
    }

    public void modifyInhibitStatus(int mask) throws IOException {
        this.conn.sendMessage(231, new byte[]{(byte)(mask & 0xFF), (byte)(mask >> 8 & 0xFF)});
    }

    public int requestInhibitStatus() throws IOException {
        byte[] data = this.conn.sendMessage(230);
        return data[0] & 255 + (data[1] & 0xFF) * 256;
    }

    public BufferedCredit readBufferedCredit() throws IOException {
        byte[] data = this.conn.sendMessage(229);
        BufferedCredit bc = new BufferedCredit();
        bc.setEventsCount(data[0] & 0xFF);
        EventPair[] eps = new EventPair[5];
        for (int i = 0; i < 5; ++i) {
            EventPair ep;
            eps[i] = ep = new EventPair(data[i * 2 + 1] & 0xFF, data[i * 2 + 2] & 0xFF);
        }
        bc.setEvents(eps);
        return bc;
    }

    public void modifyMasterInhibitStatus(int mask) throws IOException {
        this.conn.sendMessage(228, new byte[]{(byte)(mask & 0xFF)});
    }

    public int requestMasterInhibitStatus() throws IOException {
        byte[] data = this.conn.sendMessage(227);
        return data[0];
    }

    public int requestInsertionCounter() throws IOException {
        byte[] data = this.conn.sendMessage(226);
        return data[0] + (data[1] + data[2] * 256) * 256;
    }

    public int requestAcceptCounter() throws IOException {
        byte[] data = this.conn.sendMessage(225);
        return data[0] + (data[1] + data[2] * 256) * 256;
    }

    public String requestBillCode() throws IOException {
        byte[] data = this.conn.sendMessage(195);
        return new String(data);
    }

    public String requestCoinId(int position) throws IOException {
        byte[] data = this.conn.sendMessage(184, new byte[]{(byte)(position & 0xFF)});
        try {
            String res = new String(data);
            if ("......".equals(res)) {
                return null;
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void requestErrorStatus() throws IOException {
        this.conn.sendMessage(122);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.CCTalkCoin;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    public void testSolenoids(int bitmask) throws IOException {
        this.conn.sendMessage(240, this.conv(bitmask));
    }

    public void testOutputLines(int bitmask) throws IOException {
        this.conn.sendMessage(238, this.conv(bitmask));
    }

    public int readOptoStates() throws IOException {
        return BU.c((byte)this.conn.sendMessage(236)[0]);
    }

    @Override
    public void test() throws IOException {
    }

    @Override
    public ValidatorInfo getValidatorInfo() throws IOException {
        return new ValidatorInfo(this.requestManufacterId() + " " + this.requestProductCode() + " " + this.requestSoftwareRevision());
    }

    protected byte[] conv(int param) {
        return new byte[]{BU.c((int)param)};
    }

    protected byte[] conv(int param1, int param2) {
        return new byte[]{BU.c((int)param1), BU.c((int)param2)};
    }
}

