/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin.coin.cctalk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.cctalk.BufferedCredit;
import ru.softlogic.hardware.device.cashin.coin.cctalk.EventPair;
import ru.softlogic.hardware.device.cashin.coin.cctalk.ccTalkApi;
import ru.softlogic.hardware.device.cashin.coin.cctalk.resources.NominalHelper;
import ru.softlogic.hardware.device.cashin.validator.Validator;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class Driver
extends Validator {
    private final SerialPort port;
    private final ccTalkApi api;
    private final DeviceInfo info;
    private final ResourceBundle bundle;
    private Integer lastEvent;
    private int enableMask;
    private final Map<Integer, Integer> masks;
    private final Map<Integer, CashUnit> billTable;
    private volatile Sum maxSum;
    private Sum lastMaxSum;

    public Driver(SerialPort port) {
        super("coin");
        this.port = port;
        this.info = new DeviceInfo(DeviceType.CCTalkCoin);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.cashin.coin.cctalk.messages");
        this.info.setPort(port.getName());
        this.api = new ccTalkApi(port);
        this.billTable = new HashMap<Integer, CashUnit>();
        this.masks = new HashMap<Integer, Integer>();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.CCTalkCoin)));
        this.log.info((Object)("Serial params: " + this.port.getParams()));
        boolean inited = false;
        Boolean lastEnable = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!inited) {
                    this.getCoinInfo();
                    this.notifyStatus(ValidatorStatus.Init);
                    this.notifyStatus(ValidatorStatus.Ok);
                    inited = true;
                }
                if (this.lastEvent == null) {
                    BufferedCredit bc = this.api.readBufferedCredit();
                    this.lastEvent = bc.getEventsCount();
                }
                if (lastEnable == null || lastEnable != this.enable) {
                    lastEnable = this.enable;
                    if (this.enable) {
                        this.log.info((Object)"Enable coin acceptor, modify inhibit status");
                        this.api.modifyInhibitStatus(this.getMask());
                        this.log.info((Object)"Modify master inhibit status");
                        this.api.modifyMasterInhibitStatus(1);
                        this.log.info((Object)"Success");
                    } else {
                        this.log.info((Object)"Disable coin acceptor");
                        this.api.modifyInhibitStatus(0);
                        this.log.info((Object)"Disabled");
                        this.processEvents();
                    }
                }
                this.mutex.lock();
                this.processEvents();
                this.processMaxSumChange();
                this.mutex.unlock();
                ThreadUtil.sleep((long)100L);
            }
            catch (IOException ex) {
                this.mutex.unlock();
                this.log.info((Object)"I/O error", (Throwable)ex);
                ThreadUtil.sleep((long)1000L);
                this.api.close();
                inited = false;
                this.notifyStatus(ValidatorStatus.ConnectionError);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Stop thread");
    }

    boolean canStack(CashUnit cu) {
        if (this.cashStorage != null && cu != null) {
            return this.cashStorage.cashPermit(cu);
        }
        return false;
    }

    private int getMask() {
        this.log.info((Object)("Build allowed mask: " + this.coinUnits));
        if (this.coinUnits != null && !this.coinUnits.isEmpty()) {
            int allowed = 0;
            for (CashUnit cu : this.coinUnits) {
                Integer mask = this.masks.get(cu.getId());
                if (!this.canStack(cu) || mask == null || this.lastMaxSum != null && this.lastMaxSum.compareTo(cu.getNominal()) < 0) continue;
                allowed += mask.intValue();
            }
            this.log.info((Object)("Allowed mask = " + String.format("0x%04x", allowed)));
            this.log.info((Object)("Final mask: " + String.format("0x%04x", this.enableMask & allowed)));
            return this.enableMask & allowed;
        }
        this.log.info((Object)"Coins not found");
        int allowed = 0;
        for (Map.Entry<Integer, CashUnit> cue : this.billTable.entrySet()) {
            CashUnit cu = cue.getValue();
            Integer mask = this.masks.get(cu.getId());
            if (!this.canStack(cu)) continue;
            allowed += mask.intValue();
        }
        this.log.info((Object)("Allowed mask = " + String.format("0x%04x", allowed)));
        this.log.info((Object)("Final mask: " + String.format("0x%04x", this.enableMask & allowed)));
        return this.enableMask & allowed;
    }

    private void processEvents() throws IOException {
        BufferedCredit bc = this.api.readBufferedCredit();
        if (bc.getEventsCount() != this.lastEvent.intValue()) {
            int diff = this.getDiff(bc.getEventsCount(), this.lastEvent);
            this.lastEvent = bc.getEventsCount();
            this.log.info((Object)("Events in buffer: " + diff));
            if (diff > 5) {
                this.log.info((Object)("Lost data about " + (diff - 5) + " events"));
                diff = 5;
            }
            EventPair[] pairs = bc.getEvents();
            for (int i = 0; i < diff; ++i) {
                EventPair ep = pairs[i];
                if (ep.getA() > 0 && ep.getA() < 255) {
                    this.log.info((Object)("Sorter path: " + ep.getB()));
                    this.log.info((Object)("Bill type " + ep.getA() + " validated correctly and sent to cashbox"));
                    CashUnit cu = this.billTable.get(ep.getA());
                    if (cu != null) {
                        this.log.info((Object)("Get coin: " + cu));
                        this.notifyCash(cu);
                        this.cashStorage.addCash(cu);
                    }
                    this.notifyStatus(ValidatorStatus.Ok);
                    continue;
                }
                if (ep.getA() == 0) {
                    this.log.info((Object)("Event: " + this.getEventInfo(ep)));
                    switch (ep.getB()) {
                        case 1: {
                            this.notifyStatus(ValidatorStatus.Ok);
                            break;
                        }
                        case 14: {
                            this.notifyStatus(ValidatorStatus.JammInHead);
                            break;
                        }
                    }
                    continue;
                }
                this.log.info((Object)("Unknown event: " + ep));
            }
        }
    }

    private void getCoinInfo() throws IOException {
        try {
            Integer def;
            this.log.info((Object)("Try to open port " + this.port.getName()));
            this.api.open();
            this.api.simplePoll();
            String manufacter = this.api.requestManufacterId();
            this.info.setVendor(manufacter);
            this.log.info((Object)("Manufacturer: " + manufacter));
            String product = this.api.requestProductCode();
            this.info.setModel(product);
            this.log.info((Object)("Model: " + product));
            int serial = this.api.requestSerialNumber();
            this.info.setSerial("" + serial);
            this.log.info((Object)("Serial number: " + serial));
            String software = this.api.requestSoftwareRevision();
            this.info.setFirmware(software);
            this.log.info((Object)("Software revision: " + software));
            String catId = this.api.requestEquipmentCategoryId();
            this.log.info((Object)("Category Id: " + catId));
            try {
                String scaleFactor = this.api.requestCountryScalingFactor("KZ");
                this.log.info((Object)("Scale factor: " + scaleFactor));
            }
            catch (IOException ex) {
                this.log.error((Object)"Scale factor is unavaliable");
            }
            Map<String, Integer> so = this.readSorterOptions();
            if (so != null && (def = so.get("DEFAULT")) != null) {
                this.log.info((Object)("Sorter def=" + def));
                this.api.modifyDefaultSorterPath(def);
                this.log.info((Object)("Def sorter paths: " + this.api.requestDefaultSorterPath()));
            }
            this.log.info((Object)"Get coin description:");
            this.billTable.clear();
            this.masks.clear();
            this.enableMask = 0;
            for (int i = 1; i <= 16; ++i) {
                try {
                    String name = this.api.requestCoinId(i);
                    if (name == null) break;
                    this.log.info((Object)("  id=" + i + ", name=" + name));
                    if (name.endsWith("A  ")) {
                        String newName = name.replace("A  ", "00A");
                        this.log.warn((Object)("\u0418\u0441\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u0443\u043f\u044e\u0440\u044b: " + name + "->" + newName));
                        name = newName;
                    }
                    if (so != null && so.get(name) != null) {
                        this.log.info((Object)("  sort to->" + so.get(name)));
                        this.api.modifySorterPaths(i, so.get(name));
                    }
                    NominalHelper helper = new NominalHelper(product, software);
                    if (name.length() == 6) {
                        CashFactory cf;
                        this.log.debug((Object)("name =" + name));
                        String country = name.substring(0, 2);
                        String nominal = helper.getNominal(name);
                        if (nominal == null) {
                            nominal = this.parsNominal(name.substring(2, 5));
                        }
                        if ((cf = CashFactory.getInstance((String)country)) != null) {
                            if (nominal.matches("\\d+")) {
                                CashUnit cu = cf.getCoinUnitByNominal(new Sum(Integer.parseInt(nominal)));
                                if (cu != null) {
                                    this.log.info((Object)("  " + i + "->Add coin: " + cu));
                                    this.billTable.put(i, cu);
                                    int cm = this.masks.get(cu.getId()) == null ? 0 : this.masks.get(cu.getId());
                                    this.masks.put(cu.getId(), 1 << i - 1 | cm);
                                    this.enableMask += 1 << i - 1;
                                    continue;
                                }
                                this.log.error((Object)("Coin does not exist in the system table, nominal: " + nominal + ", country: " + country));
                                continue;
                            }
                            this.log.info((Object)("Nominal is unknown: " + nominal));
                            continue;
                        }
                        this.log.info((Object)"Currency is unknown");
                        continue;
                    }
                    this.log.info((Object)"Not specified denomination. Ignored");
                    continue;
                }
                catch (IOException ex) {
                    this.log.info((Object)("  id=" + i + ", name=<undefined>"));
                }
            }
            this.log.info((Object)("Coin table: " + this.billTable));
            this.log.info((Object)"Masks table: ");
            for (Integer key : this.masks.keySet()) {
                this.log.info((Object)("    " + key + "->" + String.format("%04x", this.masks.get(key))));
            }
            this.log.info((Object)("Mask: " + String.format("0x%04x ", this.enableMask)));
        }
        catch (IOException ex) {
            this.log.error((Object)"I/O error", (Throwable)ex);
            throw ex;
        }
    }

    private int getDiff(int current, int last) {
        if (current > last) {
            return current - last;
        }
        return current - last + 255;
    }

    private String getEventInfo(EventPair ep) {
        try {
            String msg = this.bundle.getString("coin.error." + ep.getB());
            return msg + "," + ep;
        }
        catch (Throwable ex) {
            return "Unknown status, " + ep;
        }
    }

    public String toString() {
        return "CoinAccetor[ccTalk]";
    }

    @Override
    public void setMaxSum(Sum sum) {
        this.log.info((Object)("Change max sum: " + sum));
        this.maxSum = sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> readSorterOptions() {
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(PathUtils.getAppHome() + "/resources/payout/sorter");
            prop.load(fis);
            HashMap<String, Integer> res = new HashMap<String, Integer>();
            for (String p : prop.stringPropertyNames()) {
                String v = prop.getProperty(p);
                if (v == null || !v.matches("^\\d+$")) continue;
                res.put(p, Integer.parseInt(v));
            }
            this.log.info((Object)("Sorter options: " + res));
            HashMap<String, Integer> hashMap = res;
            IOUtils.closeQuietly((InputStream)fis);
            return hashMap;
        }
        catch (IOException ex) {
            Map<String, Integer> map = null;
            return map;
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    private String parsNominal(String source) {
        Matcher m2;
        String result = "######";
        if (source.matches("\\d{0,3}[KMkmGg]{0,1}\\d{0,1}") && (m2 = Pattern.compile("(\\d{0,3})([KMkmGg]{0,1})(\\d{0,1})").matcher(source)).find()) {
            int cel = m2.group(1) == null || m2.group(1).isEmpty() ? 0 : Integer.parseInt(m2.group(1));
            String step = m2.group(2);
            int ost = m2.group(3) == null || m2.group(3).isEmpty() ? 0 : Integer.parseInt(m2.group(3));
            int exponent = 0;
            if ("k".equals(step.toLowerCase())) {
                exponent = 3;
            } else if ("m".equals(step.toLowerCase())) {
                exponent = 6;
            } else if ("g".equals(step.toLowerCase())) {
                exponent = 9;
            }
            result = "" + (cel * (int)Math.pow(10.0, exponent) + ost * (int)Math.pow(10.0, exponent > 0 ? (double)(exponent - 1) : 0.0));
        }
        return result;
    }

    private void processMaxSumChange() throws IOException {
        Sum ms = this.maxSum;
        if (this.enable && (this.lastMaxSum == null && ms != null || this.lastMaxSum != null && !this.lastMaxSum.equals((Object)ms))) {
            this.lastMaxSum = ms;
            this.log.info((Object)"Modify mask");
            this.api.modifyInhibitStatus(this.getMask());
            this.log.info((Object)"Done");
        }
    }
}

