/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cashin;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import ru.softlogic.cash.Keeper;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.reference.point.Bank;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.ServerUser;

public class MoneyCollection
implements Serializable {
    static final long serialVersionUID = 1590627601133878533L;
    private int id;
    private Date lastDate;
    private Date date;
    private Keeper keeper;
    private DeviceClass deviceClass;
    private ServerUser menuUser;
    private Point point;
    private Dealer dealer;
    private PaymentSystem paymentSystem;
    private Bank bank;
    private boolean payout = false;
    private Map<Integer, Map<Denomination, Integer>> dispenserStore;
    private Map<Denomination, Integer> dispenserReject;

    public MoneyCollection() {
    }

    public MoneyCollection(int id, Keeper keeper, DeviceClass deviceClass, Date lastDate, ServerUser menuUser) {
        this.id = id;
        this.keeper = keeper;
        this.deviceClass = deviceClass;
        this.lastDate = lastDate;
        this.date = new Date();
        this.menuUser = menuUser;
    }

    public int getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public Keeper getKeeper() {
        return this.keeper;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public ServerUser getMenuUser() {
        return this.menuUser;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public Dealer getDealer() {
        return this.dealer;
    }

    public void setDealer(Dealer dealer) {
        this.dealer = dealer;
    }

    public PaymentSystem getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(PaymentSystem paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public boolean isPayout() {
        return this.payout;
    }

    public void setPayout(boolean payout) {
        this.payout = payout;
    }

    public Map<Integer, Map<Denomination, Integer>> getDispenserStore() {
        return this.dispenserStore;
    }

    public void setDispenserStore(Map<Integer, Map<Denomination, Integer>> dispenserStore) {
        this.dispenserStore = dispenserStore;
    }

    public Map<Denomination, Integer> getDispenserReject() {
        return this.dispenserReject;
    }

    public void setDispenserReject(Map<Denomination, Integer> dispenserReject) {
        this.dispenserReject = dispenserReject;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", class=" + (Object)((Object)this.deviceClass) + ", date=" + this.date + " keeper=" + this.keeper + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneyCollection other = (MoneyCollection)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.date == other.date || this.date != null && this.date.equals(other.date);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + this.id;
        hash = 41 * hash + (this.date != null ? this.date.hashCode() : 0);
        return hash;
    }
}

