/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device;

import java.util.LinkedList;
import javax.xml.bind.annotation.XmlEnum;
import ru.softlogic.hardware.device.DeviceClass;

@XmlEnum
public enum DeviceType {
    GenericModem(DeviceClass.Modem, 12, "GenericModem"),
    Alarm(DeviceClass.WatchDog, 22, "Alarm"),
    Ccnet(DeviceClass.CashAcceptor, 0, "Ccnet"),
    Id003(DeviceClass.CashAcceptor, 1, "Id003"),
    Ebds(DeviceClass.CashAcceptor, 38, "Ebds"),
    Ict004(DeviceClass.CashAcceptor, 2, "Ict004"),
    ValidatorStub(DeviceClass.CashAcceptor, 36, "ValidatorStub"),
    ValidatorStub2(DeviceClass.CashAcceptor, 37, "ValidatorStub2"),
    ValidatorStub2Pay(DeviceClass.CashAcceptor, 39, "ValidatorStub2Pay"),
    NV200(DeviceClass.CashAcceptor, 100, "NV200"),
    SmartPayout(DeviceClass.CashAcceptor, 101, "SmartPayout"),
    SspValidator(DeviceClass.CashAcceptor, 102, "SspValidator"),
    Mdb(DeviceClass.CashAcceptor, 103, "Mdb"),
    GPT22(DeviceClass.CashAcceptor, 105, "gpt22"),
    ValidatorStubManual(DeviceClass.CashAcceptor, 108, "ValidatorStubManual"),
    MeiCF7000(DeviceClass.CoinAcceptor, 85, "MeiCF7000"),
    CurrenzaC2(DeviceClass.CoinAcceptor, 107, "CurrenzaC2"),
    EU9Coin(DeviceClass.CoinAcceptor, 83, "EU9Coin"),
    CCTalkCoin(DeviceClass.CoinAcceptor, 40, "CCTalkCoin"),
    Sapfir(DeviceClass.WatchDog, 45, "Sapfir"),
    Osmp(DeviceClass.WatchDog, 3, "Osmp"),
    Online(DeviceClass.WatchDog, 4, "Online", false),
    Software(DeviceClass.WatchDog, 13, "Software"),
    SimpleRTS(DeviceClass.WatchDog, 14, "SimpleRTS"),
    SoftLogic(DeviceClass.WatchDog, 16, "SoftLogic", false),
    StragGSM(DeviceClass.WatchDog, 17, "StragGSM"),
    Avangard(DeviceClass.WatchDog, 31, "Avangard", false),
    Platix(DeviceClass.WatchDog, 55, "Platix"),
    External(DeviceClass.WatchDog, 44, "External"),
    LDog(DeviceClass.WatchDog, 52, "LDog"),
    Karat1(DeviceClass.WatchDog, 67, "Karat1"),
    Karat2(DeviceClass.WatchDog, 68, "Karat2"),
    ShtrihPrinter(DeviceClass.PosPrinter, 19, "ShtrihPrinter"),
    ShtrihKkm(DeviceClass.FiscalPrinter, 20, "ShtrihKkm"),
    RpSystemKkm(DeviceClass.FiscalPrinter, 51, "RpSystemKkm"),
    PayonlineKkm(DeviceClass.FiscalPrinter, 89, "PayonlineKkm"),
    ShtrihFrkKkm(DeviceClass.FiscalPrinter, 53, "ShtrihFrkKkm"),
    YarusPrinter(DeviceClass.PosPrinter, 34, "YarusPrinter"),
    YarusKkm(DeviceClass.FiscalPrinter, 35, "YarusKkm"),
    AtolPrinter(DeviceClass.PosPrinter, 24, "AtolPrinter"),
    AtolKkm(DeviceClass.FiscalPrinter, 25, "AtolKkm"),
    TreasurerPrinter(DeviceClass.PosPrinter, 110, "TreasurerPrinter"),
    TreasurerKkm(DeviceClass.FiscalPrinter, 111, "TreasurerKkm"),
    TfaPrinter(DeviceClass.PosPrinter, 112, "TfaKkm"),
    TfaKkm(DeviceClass.FiscalPrinter, 113, "TfaKkm"),
    ComepayPrinter(DeviceClass.PosPrinter, 46, "ComepayPrinter"),
    ComepayKkm(DeviceClass.FiscalPrinter, 47, "ComepayKkm"),
    HelpMicroPrinter(DeviceClass.PosPrinter, 26, "HelpMicroPrinter", false),
    HelpMicroKkm(DeviceClass.FiscalPrinter, 27, "HelpMicroKkm", false),
    IskraPrinter(DeviceClass.PosPrinter, 28, "IskraPrinter"),
    IskraKkm(DeviceClass.FiscalPrinter, 29, "IskraKkm"),
    GenericPosPrinter(DeviceClass.PosPrinter, 9, "GenericPosPrinter"),
    GenericPosPrinterDdc(DeviceClass.PosPrinter, 43, "GenericPosPrinterDdc"),
    CustomVkp80(DeviceClass.PosPrinter, 5, "CustomVkp80"),
    CustomTg2480(DeviceClass.PosPrinter, 41, "CustomTg2480"),
    Swecoin2000(DeviceClass.PosPrinter, 6, "Swecoin2000"),
    Epson500(DeviceClass.PosPrinter, 7, "Epson500"),
    CitizenCbm1000(DeviceClass.PosPrinter, 15, "CitizenCbm1000"),
    CitizenPpu232(DeviceClass.PosPrinter, 18, "CitizenPpu232"),
    CitizenCTS2000(DeviceClass.PosPrinter, 84, "CitizenCTS2000"),
    StarLinePrinter(DeviceClass.PosPrinter, 10, "StarLinePrinter"),
    SysfutureAv268(DeviceClass.PosPrinter, 8, "SysfutureAv268"),
    GeBE(DeviceClass.PosPrinter, 21, "GeBE"),
    GeBE2(DeviceClass.PosPrinter, 23, "GeBE2"),
    GP58CA(DeviceClass.PosPrinter, 30, "GP58CA"),
    PosPrinterStub(DeviceClass.PosPrinter, 56, "PosPrinterStub"),
    Hwasung(DeviceClass.PosPrinter, 64, "Hwasung"),
    SnbcT080(DeviceClass.PosPrinter, 65, "SnbcT080"),
    IppPrinter(DeviceClass.IppPrinter, 11, "IppPrinter"),
    Sankyo(DeviceClass.CardReader, 42, "sankyo3k5"),
    Creator(DeviceClass.CardReader, 57, "Creator"),
    Verifone(DeviceClass.CardReader, 66, "Verifone"),
    Sagem(DeviceClass.Pinpad, 48, "Sagem"),
    Zt588(DeviceClass.Pinpad, 49, "Zt588"),
    Zt596(DeviceClass.Pinpad, 50, "Zt596"),
    Zt598m(DeviceClass.Pinpad, 104, "Zt598m"),
    KeyboardPinpad(DeviceClass.Pinpad, 62, "KeyboardPinpad"),
    SmartHopper(DeviceClass.Hopper, 54, "SmartHopper"),
    SCH2Hopper(DeviceClass.Hopper, 63, "SCH2Hopper"),
    MetrologicScanner(DeviceClass.BarcodeScanner, 58, "MetrologicScanner"),
    KeyboardScanner(DeviceClass.BarcodeScanner, 59, "KeyboardScanner", false),
    MetrologicScannerText(DeviceClass.BarcodeScanner, 82, "MetrologicScannerText"),
    CinoScanner(DeviceClass.BarcodeScanner, 109, "CinoScanner"),
    VoidScanner(DeviceClass.BarcodeScanner, 60, "VoidScanner", false),
    PcscScanner(DeviceClass.BarcodeScanner, 90, "PcscScanner"),
    MicroemProximityReader(DeviceClass.ProximityReader, 61, "MicroemProximityReader"),
    RosanProximityReader(DeviceClass.ProximityReader, 70, "RosanProximityReader"),
    LeaderCandy(DeviceClass.Dispenser, 69, "LeaderCandy"),
    Avangard2(DeviceClass.WatchDog, 71, "Avangard2"),
    CitizenPpu700(DeviceClass.PosPrinter, 72, "CitizenPpu700"),
    IPI1120E(DeviceClass.PosPrinter, 86, "IPI1120E"),
    TouchScreen(DeviceClass.TouchScreen, 73, "TouchScreen"),
    ItlValidator(DeviceClass.CashAcceptor, 74, "ItlValidator"),
    Cvd300(DeviceClass.CardDispenser, 75, "Cvd300"),
    Crt530(DeviceClass.CardDispenser, 76, "Crt530"),
    Crt571(DeviceClass.CardDispenser, 81, "Crt571"),
    CdmStub(DeviceClass.CashDispenser, 77, "CdmStub"),
    Puloon2000(DeviceClass.CashDispenser, 78, "Puloon2000"),
    Puloon4000(DeviceClass.CashDispenser, 79, "Puloon4000"),
    SimpleCoffeeMachine(DeviceClass.CoffeeDispenser, 80, "SimpleCoffeeMachine"),
    SimpleSnackMachine(DeviceClass.SnackDispenser, 81, "SimpleSnackMachine"),
    LeokasPrinter(DeviceClass.PosPrinter, 87, "LeokasPrinter"),
    LeokasKkm(DeviceClass.FiscalPrinter, 88, "LeokasKkm");

    private final DeviceClass deviceClass;
    private final boolean active;
    private final short deviceType;
    private final String name;

    private DeviceType(DeviceClass deviceClass, short deviceType, String name) {
        this(deviceClass, deviceType, name, true);
    }

    private DeviceType(DeviceClass deviceClass, short deviceType, String name, boolean active) {
        this.deviceClass = deviceClass;
        this.active = active;
        this.deviceType = deviceType;
        this.name = name;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public boolean isActive() {
        return this.active;
    }

    public short getDeviceType() {
        return this.deviceType;
    }

    public static DeviceType[] getByDeviceClass(DeviceClass deviceClass) {
        LinkedList<DeviceType> res = new LinkedList<DeviceType>();
        for (DeviceType type : DeviceType.values()) {
            if (type.getDeviceClass() != deviceClass) continue;
            res.add(type);
        }
        DeviceType[] res1 = new DeviceType[res.size()];
        return res.toArray(res1);
    }

    public static DeviceType[] getByDeviceClass(DeviceClass deviceClass, boolean active) {
        LinkedList<DeviceType> res = new LinkedList<DeviceType>();
        for (DeviceType type : DeviceType.values()) {
            if (type.getDeviceClass() != deviceClass || type.isActive() != active) continue;
            res.add(type);
        }
        DeviceType[] res1 = new DeviceType[res.size()];
        return res.toArray(res1);
    }

    public String getName() {
        return this.name;
    }
}

