/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.api;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.DeviceApi;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.coin.cctalk.ccTalkApi;
import ru.softlogic.hardware.device.cashin.coin.eu.EU9Api;
import ru.softlogic.hardware.device.cashin.coin.mei.MeiMDBApi;
import ru.softlogic.hardware.device.cashin.coin.nriC2.CurenzaApi;
import ru.softlogic.hardware.device.cashin.validator.ccnet.CcnetApi;
import ru.softlogic.hardware.device.cashin.validator.ebds.EbdsApi;
import ru.softlogic.hardware.device.cashin.validator.gpt22.Gpt22Api;
import ru.softlogic.hardware.device.cashin.validator.ict004.Ict004Api;
import ru.softlogic.hardware.device.cashin.validator.id003.Id003Api;
import ru.softlogic.hardware.device.cashin.validator.itl.AppNv200Api;
import ru.softlogic.hardware.device.cashin.validator.mdb.MDBApi;
import ru.softlogic.hardware.device.cdm.CdmStub;
import ru.softlogic.hardware.device.cdm.Puloon2000;
import ru.softlogic.hardware.device.cdm.Puloon4000;
import ru.softlogic.hardware.device.crd.Sankyo3k5Api;
import ru.softlogic.hardware.device.cvd.Crt530Api;
import ru.softlogic.hardware.device.cvd.Crt571Api;
import ru.softlogic.hardware.device.cvd.Cvd300Api;
import ru.softlogic.hardware.device.hopper.sch2.Sch2Api;
import ru.softlogic.hardware.device.hopper.smart.AppSmartHopperApi;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.hardware.device.print.kkm.atol.AtolApi;
import ru.softlogic.hardware.device.print.kkm.atol.AtolPrinter;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayApi;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayPrinter;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroApi;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraApi;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraPrinter;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoApi;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Api;
import ru.softlogic.hardware.device.print.kkm.shtrih.ShtrihPrinter;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaApi;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerApi;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerPrinter;
import ru.softlogic.hardware.device.print.kkm.yarus.YarusPrinter;
import ru.softlogic.hardware.device.print.posprinter.api.ParallelPrinterApi;
import ru.softlogic.hardware.device.print.posprinter.api.SerialPrinterApi;
import ru.softlogic.hardware.device.print.posprinter.api.UsbPrinterApi;
import ru.softlogic.hardware.device.print.posprinter.drv.Av268Api_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCTS2000Api_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCTS2000Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCbm1000_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCbm1000_lpt;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenPpu232Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenPpu700Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenPpu700Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomTg2480Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomTg2480Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomVkp80Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomVkp80Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.Epson500Api_lpt;
import ru.softlogic.hardware.device.print.posprinter.drv.GeBE;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2_lpt;
import ru.softlogic.hardware.device.print.posprinter.drv.Hwasung_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.IPI1120EPrinter_com;
import ru.softlogic.hardware.device.print.posprinter.drv.IctGP58CA;
import ru.softlogic.hardware.device.print.posprinter.drv.SnbcT080_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.StarLinePrinterApi_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.StarLinePrinterApi_lpt;
import ru.softlogic.hardware.device.print.posprinter.drv.Swecoin2000Api_bd;
import ru.softlogic.hardware.device.print.posprinter.drv.Swecoin2000Api_lpt;
import ru.softlogic.hardware.device.print.posprinter.drv.ddc.GenericPrinterApi2_bd_ddc;
import ru.softlogic.hardware.device.print.posprinter.drv.ddc.GenericPrinterApi2_lpt_ddc;
import ru.softlogic.hardware.device.proximity.microem.MicroemApi;
import ru.softlogic.hardware.device.scanner.metrologic.MetroLogicApi;
import ru.softlogic.hardware.device.watchdog.alarm.AlarmApi;
import ru.softlogic.hardware.device.watchdog.avangard.AvangardApi;
import ru.softlogic.hardware.device.watchdog.avg2.Avg2Api;
import ru.softlogic.hardware.device.watchdog.karat.Karat1Api;
import ru.softlogic.hardware.device.watchdog.karat.Karat2Api;
import ru.softlogic.hardware.device.watchdog.ldog.LDogApi;
import ru.softlogic.hardware.device.watchdog.online.OnlineApi;
import ru.softlogic.hardware.device.watchdog.osmp.OsmpApi;
import ru.softlogic.hardware.device.watchdog.sapfir.SapfirApi;
import ru.softlogic.hardware.device.watchdog.simple.SimpleApi;
import ru.softlogic.hardware.device.watchdog.softlogic.SoftLogicApi;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;

public class ApiFactory {
    public static SerialDeviceApi createDeviceApi(DeviceType type, SerialPort serialPort) {
        switch (type) {
            case CurrenzaC2: {
                return new CurenzaApi(serialPort, null);
            }
            case Ccnet: {
                return new CcnetApi(serialPort);
            }
            case Ict004: {
                return new Ict004Api(serialPort);
            }
            case Id003: {
                return new Id003Api(serialPort);
            }
            case Ebds: {
                return new EbdsApi(serialPort);
            }
            case ValidatorStub: {
                return null;
            }
            case CCTalkCoin: {
                return new ccTalkApi(serialPort);
            }
            case EU9Coin: {
                return new EU9Api(serialPort, null);
            }
            case MeiCF7000: {
                return new MeiMDBApi(serialPort, null);
            }
            case ItlValidator: {
                return new AppNv200Api(serialPort);
            }
            case Online: {
                return new OnlineApi(serialPort);
            }
            case Osmp: {
                return new OsmpApi(serialPort);
            }
            case Alarm: {
                return new AlarmApi(serialPort);
            }
            case Avangard: {
                return new AvangardApi(serialPort);
            }
            case SimpleRTS: {
                return new SimpleApi(serialPort);
            }
            case SoftLogic: {
                return new SoftLogicApi(serialPort);
            }
            case LDog: {
                return new LDogApi(serialPort);
            }
            case GenericPosPrinter: {
                return new SerialPrinterApi(serialPort, null, new GenericPrinterApi2_bd((BidirectionPort)serialPort), DeviceType.GenericPosPrinter);
            }
            case GenericPosPrinterDdc: {
                return new SerialPrinterApi(serialPort, null, new GenericPrinterApi2_bd_ddc((BidirectionPort)serialPort), DeviceType.GenericPosPrinterDdc);
            }
            case CitizenCbm1000: {
                return new SerialPrinterApi(serialPort, null, new CitizenCbm1000_bd((BidirectionPort)serialPort), DeviceType.CitizenCbm1000);
            }
            case CitizenPpu232: {
                return new CitizenPpu232Printer_com(serialPort);
            }
            case CitizenPpu700: {
                return new CitizenPpu700Printer_com(serialPort);
            }
            case IPI1120E: {
                return new IPI1120EPrinter_com(serialPort);
            }
            case CitizenCTS2000: {
                return new CitizenCTS2000Printer_com(serialPort);
            }
            case CustomVkp80: {
                return new CustomVkp80Printer_com(serialPort);
            }
            case CustomTg2480: {
                return new CustomTg2480Printer_com(serialPort);
            }
            case Swecoin2000: {
                return new SerialPrinterApi(serialPort, null, new Swecoin2000Api_bd((BidirectionPort)serialPort), DeviceType.Swecoin2000);
            }
            case SysfutureAv268: {
                SerialParams[] serialParams = new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
                return new SerialPrinterApi(serialPort, serialParams, new Av268Api_com(serialPort), DeviceType.SysfutureAv268);
            }
            case StarLinePrinter: {
                return new SerialPrinterApi(serialPort, null, new StarLinePrinterApi_bd((BidirectionPort)serialPort), DeviceType.StarLinePrinter);
            }
            case GenericModem: {
                return new GenericModemApi(serialPort);
            }
            case ShtrihPrinter: {
                return new SerialPrinterApi(serialPort, null, new ShtrihPrinter(serialPort), DeviceType.ShtrihPrinter);
            }
            case ShtrihKkm: {
                return new ru.softlogic.hardware.proto.shtihm.Api(serialPort);
            }
            case PayonlineKkm: {
                return new ru.softlogic.hardware.proto.payonline.Api(serialPort);
            }
            case RpSystemKkm: {
                return new Api(serialPort);
            }
            case YarusPrinter: {
                return new SerialPrinterApi(serialPort, null, new YarusPrinter(serialPort), DeviceType.YarusPrinter);
            }
            case AtolPrinter: {
                return new SerialPrinterApi(serialPort, null, new AtolPrinter(serialPort, null), DeviceType.AtolPrinter);
            }
            case AtolKkm: {
                return new AtolApi(serialPort);
            }
            case TreasurerPrinter: {
                return new SerialPrinterApi(serialPort, null, new TreasurerPrinter(serialPort, null), DeviceType.TreasurerPrinter);
            }
            case TreasurerKkm: {
                return new TreasurerApi(serialPort);
            }
            case TfaKkm: {
                return new TfaApi(serialPort);
            }
            case LeokasKkm: {
                return new LeoApi(serialPort);
            }
            case IskraPrinter: {
                return new SerialPrinterApi(serialPort, null, new IskraPrinter(serialPort, null), DeviceType.IskraPrinter);
            }
            case IskraKkm: {
                return new IskraApi(serialPort, null);
            }
            case ComepayPrinter: {
                return new SerialPrinterApi(serialPort, null, new ComepayPrinter(serialPort), DeviceType.ComepayPrinter);
            }
            case ComepayKkm: {
                return new ComepayApi(serialPort);
            }
            case HelpMicroPrinter: {
                return null;
            }
            case HelpMicroKkm: {
                return new HelpMicroApi(serialPort);
            }
            case GeBE: {
                SerialParams[] serialParams = new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
                return new SerialPrinterApi(serialPort, serialParams, new GeBE((BidirectionPort)serialPort, false), DeviceType.GeBE);
            }
            case GeBE2: {
                SerialParams[] serialParams = new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
                return new SerialPrinterApi(serialPort, serialParams, new GeBE((BidirectionPort)serialPort, true), DeviceType.GeBE);
            }
            case GP58CA: {
                SerialParams[] serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even)};
                return new SerialPrinterApi(serialPort, serialParams, new IctGP58CA(serialPort), DeviceType.GP58CA);
            }
            case Hwasung: {
                return new SerialPrinterApi(serialPort, null, new Hwasung_bd((BidirectionPort)serialPort), DeviceType.Hwasung);
            }
            case SnbcT080: {
                return new SerialPrinterApi(serialPort, null, new SnbcT080_bd((BidirectionPort)serialPort), DeviceType.SnbcT080);
            }
            case Sapfir: {
                return new SapfirApi(serialPort);
            }
            case SmartHopper: {
                return new AppSmartHopperApi(serialPort);
            }
            case SmartPayout: {
                return new AppNv200Api(serialPort);
            }
            case MetrologicScanner: {
                return new MetroLogicApi(serialPort);
            }
            case MicroemProximityReader: {
                return new MicroemApi(serialPort);
            }
            case SCH2Hopper: {
                return new Sch2Api(serialPort);
            }
            case Karat1: {
                return new Karat1Api(serialPort);
            }
            case Karat2: {
                return new Karat2Api(serialPort);
            }
            case Avangard2: {
                return new Avg2Api(serialPort, Logger.getLogger((String)"watchdog"));
            }
            case Cvd300: {
                return new Cvd300Api(serialPort);
            }
            case Crt530: {
                return new Crt530Api(serialPort);
            }
            case Crt571: {
                return new Crt571Api(serialPort);
            }
            case CdmStub: {
                return new CdmStub(serialPort);
            }
            case Sankyo: {
                return new Sankyo3k5Api(serialPort);
            }
            case Puloon2000: {
                return new Puloon2000(serialPort);
            }
            case Puloon4000: {
                return new Puloon4000(serialPort);
            }
            case Mdb: {
                return new MDBApi(serialPort, Logger.getLogger((String)"cashin"));
            }
            case GPT22: {
                return new Gpt22Api(serialPort, Logger.getLogger((String)"cashin"));
            }
        }
        return null;
    }

    public static DeviceApi createDeviceApi(DeviceType type, ParallelPort parallelPort) {
        switch (type) {
            case GenericPosPrinter: {
                return new ParallelPrinterApi(parallelPort, new GenericPrinterApi2_lpt(parallelPort), DeviceType.GenericPosPrinter);
            }
            case GenericPosPrinterDdc: {
                return new ParallelPrinterApi(parallelPort, new GenericPrinterApi2_lpt_ddc(parallelPort), DeviceType.GenericPosPrinterDdc);
            }
            case CitizenCbm1000: {
                return new ParallelPrinterApi(parallelPort, new CitizenCbm1000_lpt(parallelPort), DeviceType.GenericPosPrinter);
            }
            case Swecoin2000: {
                return new ParallelPrinterApi(parallelPort, new Swecoin2000Api_lpt(parallelPort), DeviceType.Swecoin2000);
            }
            case Epson500: {
                return new ParallelPrinterApi(parallelPort, new Epson500Api_lpt(parallelPort), DeviceType.Epson500);
            }
            case StarLinePrinter: {
                return new ParallelPrinterApi(parallelPort, new StarLinePrinterApi_lpt(parallelPort), DeviceType.StarLinePrinter);
            }
        }
        return null;
    }

    public static DeviceApi createDeviceApi(DeviceType type, UsbPort usbPort) {
        switch (type) {
            case GenericPosPrinter: {
                return new UsbPrinterApi(usbPort, new GenericPrinterApi2_bd((BidirectionPort)usbPort), DeviceType.GenericPosPrinter);
            }
            case GenericPosPrinterDdc: {
                return new UsbPrinterApi(usbPort, new GenericPrinterApi2_bd_ddc((BidirectionPort)usbPort), DeviceType.GenericPosPrinterDdc);
            }
            case StarLinePrinter: {
                return new UsbPrinterApi(usbPort, new StarLinePrinterApi_bd((BidirectionPort)usbPort), DeviceType.StarLinePrinter);
            }
            case Swecoin2000: {
                return new UsbPrinterApi(usbPort, new Swecoin2000Api_bd((BidirectionPort)usbPort), DeviceType.Swecoin2000);
            }
            case CustomVkp80: {
                return new CustomVkp80Printer_usb(usbPort);
            }
            case CitizenCTS2000: {
                return new UsbPrinterApi(usbPort, new CitizenCTS2000Api_bd((BidirectionPort)usbPort), DeviceType.Swecoin2000);
            }
            case CustomTg2480: {
                return new CustomTg2480Printer_usb(usbPort);
            }
            case Hwasung: {
                return new UsbPrinterApi(usbPort, new Hwasung_bd((BidirectionPort)usbPort), DeviceType.Hwasung);
            }
            case CitizenPpu700: {
                return new CitizenPpu700Printer_usb(usbPort);
            }
            case GeBE: {
                return new UsbPrinterApi(usbPort, new GeBE((BidirectionPort)usbPort, false), DeviceType.GeBE);
            }
            case GeBE2: {
                return new UsbPrinterApi(usbPort, new GeBE((BidirectionPort)usbPort, true), DeviceType.GeBE2);
            }
        }
        return null;
    }
}

