/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.textfield;

import javax.swing.JLabel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.input.model.field.numeric.NumericField;

public class ValidateNumericFieldListener
implements FieldListener {
    protected ClickButton button;
    protected JLabel errorLabel;
    protected NumericField nf;
    protected String regex;

    public ValidateNumericFieldListener(ClickButton button, JLabel errorLabel, NumericField nf) {
        if (button == null) {
            throw new NullPointerException("ClickButton");
        }
        if (errorLabel == null) {
            throw new NullPointerException("JLabel");
        }
        if (nf == null) {
            throw new NullPointerException("NumericField");
        }
        this.button = button;
        this.errorLabel = errorLabel;
        this.nf = nf;
        this.regex = nf.getDecimalCount() > 0 ? "^\\d{" + nf.getUnitCount() + "}((\\.|,)\\d{" + nf.getDecimalCount() + "})?$" : "^\\d{" + nf.getUnitCount() + "}$";
    }

    @Override
    public void onChange(String value) {
        boolean valid = this.nf.getValidator().validate(value);
        this.button.setEnabled(valid);
        this.errorLabel.setVisible(value.matches(this.regex) && !valid);
    }
}

