/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.textfield;

import java.util.HashSet;
import java.util.Set;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.input.model.field.text.Filter;

public class TextFieldModel
implements InputFieldModel {
    private int maxlen;
    private String prefix;
    private String postfix;
    private boolean readOnly;
    private Filter filter;
    private String value;
    private Set<FieldListener> listeners;

    public TextFieldModel(int maxlen, String prefix, String postfix, boolean readOnly, Filter filter) {
        if (maxlen < 0) {
            throw new IllegalArgumentException("Maxlen count must be positive");
        }
        if (filter == null) {
            throw new NullPointerException("Filter is not specified");
        }
        this.maxlen = maxlen;
        this.prefix = prefix == null ? "" : prefix;
        this.postfix = postfix == null ? "" : postfix;
        this.readOnly = readOnly;
        this.filter = filter;
        this.listeners = new HashSet<FieldListener>();
        this.value = "";
    }

    @Override
    public void add(char ch) {
        if (!this.readOnly) {
            this._add(ch, true);
        }
    }

    @Override
    public void clear() {
        if (!this.readOnly) {
            this.value = "";
            this.notifyListeners();
        }
    }

    @Override
    public void clearLast() {
        if (!this.readOnly && this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
            this.notifyListeners();
        }
    }

    @Override
    public void setValue(String value) {
        if (value != null && !value.isEmpty()) {
            for (char ch : value.toCharArray()) {
                this._add(ch, false);
            }
            this.notifyListeners();
        } else {
            this.clear();
        }
    }

    @Override
    public String getValue() {
        return this.prefix + this.value + this.postfix;
    }

    @Override
    public String getClearValue() {
        return this.value;
    }

    @Override
    public void addListener(FieldListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void notifyListeners() {
        for (FieldListener fl : this.listeners) {
            fl.onChange(this.getValue());
        }
    }

    private void _add(char ch, boolean doNotify) {
        if (this.value.length() + this.prefix.length() + this.postfix.length() < this.maxlen && this.filter.isAllowed(ch, this.prefix.length() + this.value.length())) {
            this.value = this.value + ch;
            if (doNotify) {
                this.notifyListeners();
            }
        }
    }
}

