/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.textfield;

import java.util.HashSet;
import java.util.Set;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;

public class AutoCompleteFieldModel
implements InputFieldModel {
    private String value = "";
    private Set<FieldListener> listeners = new HashSet<FieldListener>();

    @Override
    public void add(char ch) {
        this._add(ch, true);
    }

    @Override
    public void clear() {
        this.value = "";
        this.notifyListeners();
    }

    @Override
    public void clearLast() {
        if (this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
            this.notifyListeners();
        }
    }

    @Override
    public void setValue(String value) {
        if (value != null && !value.isEmpty()) {
            this.value = "";
            for (char ch : value.toCharArray()) {
                this._add(ch, false);
            }
            this.notifyListeners();
        } else {
            this.clear();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getClearValue() {
        return this.value;
    }

    @Override
    public void addListener(FieldListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void notifyListeners() {
        for (FieldListener fl : this.listeners) {
            fl.onChange(this.getValue());
        }
    }

    private void _add(char ch, boolean doNotify) {
        this.value = this.value + ch;
        if (doNotify) {
            this.notifyListeners();
        }
    }
}

