/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.listener.ng;

import java.awt.EventQueue;
import java.util.HashMap;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.gui2.screen.listener.ng.ActionNotifier;

public class SimpleActionNotifier
implements ActionNotifier {
    private int lock;
    private ScreenListener listener;

    public void setListener(ScreenListener listener) {
        this.listener = listener;
    }

    @Override
    public void init() {
        this.unlock();
    }

    @Override
    public synchronized void notify(final String type) {
        if (this.lock == 0) {
            this.lock = 1;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleActionNotifier.this.listener.onAction(type, new HashMap<String, Object>(), new LocalCancelListener());
                }
            });
        } else {
            ++this.lock;
            if (this.lock == 3 || this.lock % 10 == 0) {
                ProblemNotifier.getDefaultNotifier().onProblem("SimpleActionNotifier: Try " + type + " action on locked notifier, count: " + this.lock);
            }
            if (this.lock >= 10) {
                ProblemNotifier.getDefaultNotifier();
                ProblemNotifier.requestRestart((String)("Action blocked=" + type));
            }
        }
    }

    private synchronized void unlock() {
        this.lock = 0;
    }

    private class LocalCancelListener
    implements Runnable {
        private LocalCancelListener() {
        }

        @Override
        public void run() {
            SimpleActionNotifier.this.unlock();
        }
    }
}

