/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.listener.ng;

import java.util.LinkedHashMap;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.gui2.screen.listener.ng.ActionNotifier;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InputField;

public class NumericActionNotifier
implements ActionNotifier {
    private ScreenListener listener;
    private InputField field;
    private InputFieldModel model;
    private int lock;

    public void setField(InputField field) {
        this.field = field;
    }

    public void setListener(ScreenListener listener) {
        this.listener = listener;
    }

    public void setModel(InputFieldModel model) {
        this.model = model;
    }

    @Override
    public void init() {
        this.unlock();
    }

    @Override
    public synchronized void notify(String type) {
        if (this.lock == 0) {
            this.lock = 1;
            if (this.listener != null) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                if (ActionType.isNext(type) || ActionType.isEdit(type)) {
                    InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), null, this.model.getClearValue(), this.field.getModificator().modify(this.model.getValue()), this.field.getDataFormatter().format(this.model.getValue()), 0);
                    ie.setFlags(this.field.getFlags());
                    data.put(this.field.getId(), ie);
                    if (!this.field.getValidator().validate(this.model.getValue()) && this.field.getFailRegex() != null && !this.field.getFailRegex().isEmpty() && this.model.getValue().matches(this.field.getFailRegex())) {
                        data.put("#invalid", "true");
                    }
                }
                this.listener.onAction(type, data, new LocalCancelListener());
            }
        } else {
            ++this.lock;
            if (this.lock == 3 || this.lock % 10 == 0) {
                ProblemNotifier.getDefaultNotifier().onProblem("NumericActionNotifier: Try " + type + " action on locked notifier, count:" + this.lock);
            }
            if (this.lock >= 10) {
                ProblemNotifier.getDefaultNotifier();
                ProblemNotifier.requestRestart((String)("Action blocked=" + type));
            }
        }
    }

    private synchronized void unlock() {
        this.lock = 0;
    }

    private class LocalCancelListener
    implements Runnable {
        private LocalCancelListener() {
        }

        @Override
        public void run() {
            NumericActionNotifier.this.unlock();
        }
    }
}

