/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.listener.ng;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.listener.ng.ActionNotifier;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class CommonActionNotifier
implements ActionNotifier {
    private int lock;
    private ScreenListener listener;
    private List<InputComponent> components;

    @Override
    public void init() {
        this.unlock();
    }

    public void setListener(ScreenListener listener) {
        this.listener = listener;
    }

    public void setComponents(List<InputComponent> components) {
        this.components = components;
    }

    @Override
    public synchronized void notify(String type) {
        if (this.lock == 0) {
            this.lock = 1;
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            if (ActionType.isNext(type) || ActionType.isEdit(type) || ActionType.isSMSSuccess(type)) {
                for (InputComponent ic : this.components) {
                    ic.putData(data);
                    ic.getComponent().setEnabled(false);
                }
            }
            this.listener.onAction(type, data, new LocalCancelListener());
        } else {
            ++this.lock;
            if (this.lock == 3 || this.lock % 10 == 0) {
                ProblemNotifier.getDefaultNotifier().onProblem("CommonActionNotifier: Try " + type + " action on locked notifier, count:" + this.lock);
            }
            if (this.lock >= 10) {
                ProblemNotifier.getDefaultNotifier();
                ProblemNotifier.requestRestart((String)("Action blocked=" + type));
            }
        }
    }

    public synchronized void notifyPopup(ScreenDescription sd, ScreenListener callBackListener, Locale locale) {
        if (this.lock == 0) {
            this.lock = 1;
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            for (InputComponent ic : this.components) {
                ic.putData(data);
                ic.getComponent().setEnabled(false);
            }
            ScreenInit si = new ScreenInit(null, null, null, null, data, this.lock, this.lock, this.lock, locale, null, 0.0, true, null, null, null, null, null, null);
            this.listener.showPopup(sd, si, callBackListener);
        } else {
            ++this.lock;
            if (this.lock == 3 || this.lock % 10 == 0) {
                ProblemNotifier.getDefaultNotifier().onProblem("CommonActionNotifier: Try Popup action on locked notifier, count:" + this.lock);
            }
            if (this.lock >= 10) {
                ProblemNotifier.getDefaultNotifier();
                ProblemNotifier.requestRestart((String)"Action blocked=Popup");
            }
        }
    }

    public synchronized void notifyPopup(ScreenDescription sd, ScreenListener callBackListener) {
        this.notifyPopup(sd, callBackListener, Locale.getDefault());
    }

    private synchronized void unlock() {
        this.lock = 0;
    }

    private class LocalCancelListener
    implements Runnable {
        private LocalCancelListener() {
        }

        @Override
        public void run() {
            for (InputComponent ic : CommonActionNotifier.this.components) {
                ic.getComponent().setEnabled(true);
            }
            CommonActionNotifier.this.unlock();
        }
    }
}

