/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.gui2.screen.textfield.FieldListener;
import ru.softlogic.gui2.screen.textfield.InputFieldModel;
import ru.softlogic.gui2.screen.textfield.NumericFieldModel;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.numeric.NumericField;

public abstract class NumericInputComponent
implements InputComponent {
    protected NumericField field;
    protected JLabel component;
    protected InputFieldModel model;
    protected InputComponentListener listener;

    public NumericInputComponent(JLabel component, NumericField field, Object value, InputComponentListener listener) {
        this.field = field;
        this.listener = listener;
        this.component = component;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                NumericInputComponent.this.getFocus();
            }
        });
        this.model = new NumericFieldModel(field.getUnitCount(), field.getDecimalCount(), field.isReadOnly(), field.getFilter());
        this.model.addListener(new FieldListener(){

            @Override
            public void onChange(String value) {
                NumericInputComponent.this.component.setText(value);
                NumericInputComponent.this.listener.onChange();
            }
        });
        this.model.setValue(field.getValue());
    }

    @Override
    public boolean isValid() {
        boolean valid = this.field.getValidator().validate(this.model.getValue());
        this.setWarning(!this.model.getValue().isEmpty() && !valid);
        return valid;
    }

    @Override
    public void putData(Map<String, Object> data) {
        InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), null, this.model.getValue(), this.field.getModificator().modify(this.model.getValue()), this.component.getText(), 0);
        ie.setFlags(this.field.getFlags());
        data.put(this.field.getId(), ie);
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public InputFieldModel getModel() {
        return this.model;
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    public String toString() {
        return "NumericInputComponent{field=" + this.field + '}';
    }
}

