/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen.input;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.input.InputComponent;
import ru.softlogic.gui2.screen.input.InputComponentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;

public class CheckBoxInputComponent
implements InputComponent {
    private CheckBoxField field;
    private JCheckBox component;
    private InputComponentListener listener;

    public CheckBoxInputComponent(JCheckBox component, CheckBoxField field, Object value, InputComponentListener listener) {
        this.component = component;
        this.field = field;
        this.listener = listener;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserAction.getInstance().update();
                CheckBoxInputComponent.this.getFocus();
            }
        });
        component.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxInputComponent.this.listener.onChange();
            }
        });
        component.setText(field.getTitle());
        if (value != null && value instanceof InputElement) {
            InputElement ie = (InputElement)value;
            if (ie.getValue() != null && !ie.getValue().isEmpty()) {
                component.setSelected(!"0".equals(ie.getValue()));
            } else {
                component.setSelected(false);
            }
        } else {
            component.setSelected(false);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getHelp() {
        return this.field.getHelp();
    }

    @Override
    public void putData(Map<String, Object> data) {
        if (this.component.isSelected()) {
            InputElement ie = new InputElement(this.field.getId(), this.field.getTitle(), null, this.field.getValue(), this.field.getValue(), this.field.getText(), 0);
            ie.setFlags(this.field.getFlags());
            data.put(this.field.getId(), ie);
        } else {
            data.put(this.field.getId(), null);
        }
    }

    @Override
    public void update(Map<String, Object> data) {
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void getFocus() {
        this.listener.onSelect(this, null, null);
    }

    @Override
    public void onLostFocus() {
    }

    public String toString() {
        return "CheckBoxInputComponent{field=" + this.field + '}';
    }

    @Override
    public void setWarning(boolean warning) {
    }
}

