/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui2.screen;

import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class SafeScreenAdapter
implements ScreenListener {
    private int lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        SafeScreenAdapter safeScreenAdapter = this;
        synchronized (safeScreenAdapter) {
            this.lock = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        SafeScreenAdapter safeScreenAdapter = this;
        synchronized (safeScreenAdapter) {
            if (this.lock == 0) {
                this.lock = 1;
                this.onSafeAction(action, data, cancelListener);
            } else {
                ++this.lock;
                if (this.lock == 3 || this.lock % 10 == 0) {
                    ProblemNotifier.getDefaultNotifier().onProblem("SafeScreenAdapter: Try " + action + " action on locked notifier, count:" + this.lock);
                }
                if (this.lock >= 10) {
                    ProblemNotifier.getDefaultNotifier();
                    ProblemNotifier.requestRestart((String)("Action blocked=" + action));
                }
            }
        }
    }

    public abstract void onSafeAction(String var1, Map<String, Object> var2, Runnable var3);

    @Override
    public void onLocale(Locale locale) {
    }

    @Override
    public void onRedirect(int serviceId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
        SafeScreenAdapter safeScreenAdapter = this;
        synchronized (safeScreenAdapter) {
            if (this.lock == 0) {
                this.lock = 1;
                this.onSafePopup(sd, si, listener);
            } else {
                ++this.lock;
                if (this.lock == 3 || this.lock % 10 == 0) {
                    ProblemNotifier.getDefaultNotifier().onProblem("SafeScreenAdapter: Try Popup action on locked notifier, count:" + this.lock);
                }
                if (this.lock >= 10) {
                    ProblemNotifier.requestRestart((String)"Action blocked=Popup");
                }
            }
        }
    }

    public abstract void onSafePopup(ScreenDescription var1, ScreenInit var2, ScreenListener var3);
}

