/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class PopularServiceVisitor
extends MenuVisitorAdapter {
    private Set<Integer> list;
    private Set<MenuItem> candidates;
    private MenuItemState[] menuItemStates;

    public PopularServiceVisitor(Set<Integer> list) {
        if (list == null) {
            list = new HashSet<Integer>();
        }
        this.list = list;
        this.candidates = new LinkedHashSet<MenuItem>();
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        MenuItemState state = StateUtil.getState(mi, this.menuItemStates);
        if (state != null && (state.getButtonStatus() == ButtonStatus.Blocked || state.getButtonStatus() == ButtonStatus.Hidden)) {
            return true;
        }
        if (this.list.contains(mi.getService().getId())) {
            this.candidates.add(mi);
        }
        return true;
    }

    public Set<MenuItem> getCandidates() {
        return this.candidates;
    }
}

