/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class PayoutServiceVisitor
extends MenuVisitorAdapter {
    private List<MenuItem> candidates;
    private MenuItemState[] menuItemStates;

    public PayoutServiceVisitor() {
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        this.candidates = new LinkedList<MenuItem>();
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (MenuUtils.isMenuItemBlockedSchedule(mi)) {
            return true;
        }
        MenuItemState mis = StateUtil.getState(mi, this.menuItemStates);
        if (mis != null && mis.getButtonStatus() == ButtonStatus.Hidden) {
            return true;
        }
        if (mi.getService().isUseForChange()) {
            this.candidates.add(mi);
        }
        return true;
    }

    public List<MenuItem> getCandidates() {
        return this.candidates;
    }
}

