/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.LevenshteinDistance;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public class MenuSearchProviderVisitor
extends MenuVisitorAdapter {
    private Map<String, MenuItem> nameStart = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> altNameStart = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> name = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> altName = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> innStart = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> inn = new LinkedHashMap<String, MenuItem>();
    private Map<String, MenuItem> identificator = new LinkedHashMap<String, MenuItem>();
    private String input;
    private String inputDefault;
    private Set<Integer> blockedServices;
    private MenuItemState[] menuItemStates;
    private boolean allowSearchInHidden;

    public MenuSearchProviderVisitor(String input, String inputDefault, Set<Integer> blockedServices, boolean allowSearchInHidden) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input.toLowerCase().trim();
        if (inputDefault != null) {
            this.inputDefault = inputDefault.toLowerCase().trim();
        }
        this.blockedServices = blockedServices;
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        this.allowSearchInHidden = allowSearchInHidden;
    }

    @Override
    public boolean processGroup(ServiceType st) {
        return this.allowSearchInHidden || st == null || st.getName() == null || !st.getName().startsWith("#") && !st.getHidden();
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        String[] split;
        MenuItemState state = StateUtil.getState(mi, this.menuItemStates);
        if (state != null && (state.getButtonStatus() == ButtonStatus.Blocked || state.getButtonStatus() == ButtonStatus.Hidden)) {
            return true;
        }
        String nameService = mi.getService().getName().trim();
        if (!this.input.trim().isEmpty()) {
            String[] split2;
            if (this.blockedServices.contains(mi.getService().getId())) {
                return true;
            }
            if (mi.getService().getProvider() != null && mi.getService().getProvider().getInn() != null) {
                String providerInn = mi.getService().getProvider().getInn().toLowerCase();
                if (providerInn.trim().startsWith(this.input)) {
                    this.innStart.put(nameService, mi);
                }
                if (providerInn.contains(this.input)) {
                    this.inn.put(mi.getService().getName().trim(), mi);
                }
            }
            if (mi.getService().getAltName() != null) {
                for (String s : split = mi.getService().getAltName().split(",")) {
                    if (s == null || !s.toLowerCase().trim().startsWith(this.input)) continue;
                    this.altNameStart.put(nameService + " (" + s.trim() + ")", mi);
                    break;
                }
            }
            if (nameService.toLowerCase().startsWith(this.input)) {
                this.nameStart.put(nameService, mi);
            }
            if (mi.getService().getAltName() != null) {
                for (String s : split = mi.getService().getAltName().split(",")) {
                    if (s == null || !s.toLowerCase().contains(this.input)) continue;
                    this.altName.put(nameService + " (" + s.trim() + ")", mi);
                    break;
                }
            }
            String sName = nameService.toLowerCase();
            boolean flag = true;
            for (String s : split2 = this.input.split(" ")) {
                if (sName.contains(s)) continue;
                flag = false;
                break;
            }
            if (flag) {
                this.name.put(nameService, mi);
            } else {
                String s1 = sName.replace(" ", "");
                String s2 = this.input.replace(" ", "");
                int min = s1.length();
                if (s2.length() < min) {
                    min = s2.length();
                }
                if (this.input.length() > 2 && LevenshteinDistance.getDamerauLevenshteinDistance(s1.substring(0, min), s2.substring(0, min)) < 2) {
                    this.name.put(nameService, mi);
                }
            }
        }
        if (this.inputDefault != null) {
            split = this.inputDefault.split(",");
            int serviceId = mi.getService().getId();
            for (String key : split) {
                if (!("" + serviceId).equals(key)) continue;
                this.identificator.put(nameService, mi);
                break;
            }
        }
        return true;
    }

    private LinkedHashMap<String, MenuItem> addItem(Map<String, MenuItem> data, Set<String> keys) {
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        for (Map.Entry<String, MenuItem> entry : data.entrySet()) {
            if (keys.contains(entry.getKey().toLowerCase())) continue;
            items.put(entry.getKey(), entry.getValue());
            keys.add(entry.getKey().toLowerCase());
        }
        return items;
    }

    public Map<String, MenuItem> getItems() {
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        HashSet<String> keys = new HashSet<String>();
        items.putAll(this.addItem(this.nameStart, keys));
        items.putAll(this.addItem(this.altNameStart, keys));
        items.putAll(this.addItem(this.name, keys));
        items.putAll(this.addItem(this.altName, keys));
        items.putAll(this.addItem(this.innStart, keys));
        items.putAll(this.addItem(this.inn, keys));
        return items;
    }

    private LinkedHashMap<String, MenuItem> addItemFull(Map<String, MenuItem> data, Set<Integer> keys, int max) {
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        for (Map.Entry<String, MenuItem> entry : data.entrySet()) {
            if (max != -1 && keys.size() >= max) break;
            if (keys.contains(entry.getValue().getService().getId())) continue;
            items.put(entry.getKey(), entry.getValue());
            keys.add(entry.getValue().getService().getId());
        }
        return items;
    }

    public Map<String, MenuItem> getItemsFull(int max) {
        LinkedHashMap<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
        HashSet<Integer> keys = new HashSet<Integer>();
        items.putAll(this.addItemFull(this.nameStart, keys, max));
        items.putAll(this.addItemFull(this.altNameStart, keys, max));
        items.putAll(this.addItemFull(this.name, keys, max));
        items.putAll(this.addItemFull(this.altName, keys, max));
        items.putAll(this.addItemFull(this.innStart, keys, max));
        items.putAll(this.addItemFull(this.inn, keys, max));
        for (Map.Entry<String, MenuItem> entry : this.identificator.entrySet()) {
            if (keys.contains(entry.getValue().getService().getId())) continue;
            items.put(entry.getKey(), entry.getValue());
            keys.add(entry.getValue().getService().getId());
        }
        return items;
    }
}

