/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;

public class MenuItemByIdExtractor
extends MenuVisitorAdapter {
    private Set<Integer> candidates;
    private List<MenuItem> menuItems;
    private List<ServiceType> serviceTypes;

    public MenuItemByIdExtractor(Set<Integer> candidates) {
        if (candidates == null) {
            throw new NullPointerException();
        }
        this.candidates = candidates;
        this.menuItems = new LinkedList<MenuItem>();
        this.serviceTypes = new LinkedList<ServiceType>();
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (this.candidates.contains(mi.getIdMenuItem())) {
            this.menuItems.add(mi);
        }
        return true;
    }

    @Override
    public boolean onGroup(ServiceType st) {
        for (Integer needID : this.candidates) {
            if (st.getId() != needID.intValue()) continue;
            this.serviceTypes.add(st);
        }
        return true;
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public List<ServiceType> getServiceTypes() {
        return this.serviceTypes;
    }
}

