/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils.menu;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitorAdapter;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class MenuByPropertyVisitor
extends MenuVisitorAdapter {
    private List<MenuItem> items;
    private String property;
    private String propertyRegex;
    private MenuItemState[] menuItemStates;

    public MenuByPropertyVisitor(String property) {
        this(property, null);
    }

    public MenuByPropertyVisitor(String property, String propertyRegex) {
        this.property = property;
        this.propertyRegex = propertyRegex;
        this.items = new LinkedList<MenuItem>();
        try {
            this.menuItemStates = ReferenceManager.getInstance().getMenuItemStates();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (mi == null || mi.getService() == null || mi.getService().getProperties() == null) {
            return true;
        }
        if (MenuUtils.isMenuItemBlockedSchedule(mi)) {
            return true;
        }
        MenuItemState mis = StateUtil.getState(mi, this.menuItemStates);
        if (mis != null && mis.getButtonStatus() == ButtonStatus.Hidden) {
            return true;
        }
        if (mi.getService().getProperties().containsKey(this.property)) {
            String val = (String)mi.getService().getProperties().get(this.property);
            if (this.propertyRegex != null && !this.propertyRegex.trim().isEmpty()) {
                if (val != null && val.matches(this.propertyRegex)) {
                    this.items.add(mi);
                }
            } else if (val != null && !val.trim().isEmpty()) {
                this.items.add(mi);
            }
        }
        return true;
    }

    public List<MenuItem> getItems() {
        return this.items;
    }
}

