/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.system.util.PathUtils;

public class VSTemplateProcessor {
    private Logger log;
    private Properties properties;

    public VSTemplateProcessor(String home) {
        if (home == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438");
        }
        this.log = Logger.getLogger((String)"test");
        this.properties = new Properties();
        this.properties.setProperty("file.resource.loader.path", home);
        this.properties.setProperty("runtime.log.logsystem.log4j.logger", "test");
        this.properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
    }

    public String process(String templateName) {
        return this.process(templateName, null);
    }

    public String process(String templateName, Map<String, Object> customProperties) {
        VelocityEngine ve = null;
        Template template = null;
        try {
            ve = new VelocityEngine(this.properties);
            template = ve.getTemplate(templateName, "utf-8");
        }
        catch (Exception ex) {
            this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430", (Throwable)ex);
            return null;
        }
        ReferenceManager ref = null;
        try {
            ref = ReferenceManager.getInstance();
        }
        catch (ReferenceException ex) {
            this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432", (Throwable)ex);
            return null;
        }
        this.log.info((Object)ref.getDealer());
        VelocityContext context = new VelocityContext();
        context.put("dateFormat", (Object)new SimpleDateFormat("dd.MM.yyyy HH:mm:ss"));
        context.put("dealer", (Object)ref.getDealer());
        context.put("point", (Object)ref.getPoint());
        context.put("bank", (Object)ref.getBank());
        context.put("paysys", (Object)ref.getPaymentSystem());
        context.put("menu", (Object)ref.getMenu());
        context.put("terminal_home", (Object)PathUtils.getAppHome());
        if (customProperties != null) {
            for (Map.Entry<String, Object> obj : customProperties.entrySet()) {
                context.put(obj.getKey(), obj.getValue());
            }
        }
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)context, (Writer)sw);
            return sw.toString();
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0438 \u043e\u0442\u0447\u0435\u0442\u0430", (Throwable)ex);
            return "";
        }
    }
}

