/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.point.NotificationProfile;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionUnit;

public class SmsSuccessVerifier {
    public static final String SMS_SUCCESS_FIELD = "sms-check";
    public static final String SMS_NOTIFY_DISABLE = "atm_disable_sms_notify";

    public static boolean isEnabled(ScreenInit si) {
        Service service = si.getService();
        Point point = si.getPoint();
        Map<String, Object> data = si.getData();
        return SmsSuccessVerifier.isEnabled(service, point, data);
    }

    public static boolean isEnabled(Service service, Point point, Map<String, Object> data) {
        if ("1".equals(point.getAttributes().get(SMS_NOTIFY_DISABLE))) {
            return false;
        }
        Object get = data.get(service.getSuccessSmsPhone());
        if (get instanceof InputElement) {
            InputElement ie = (InputElement)get;
            if ((ie.getOriginalValue() == null || ie.getOriginalValue().isEmpty()) && (ie.getValue() == null || ie.getValue().isEmpty())) {
                return false;
            }
        } else {
            return false;
        }
        return service.getSuccessSms() != false && point.getNotificationProfile() != null && point.getNotificationProfile().getCost() != null && service.getSuccessSmsPhone() != null && !service.getSuccessSmsPhone().isEmpty();
    }

    public static boolean isEnabled(Service service, Point point, List<InputElement> data) {
        if (service.getSuccessSms().booleanValue() && point.getNotificationProfile() != null && point.getNotificationProfile().getCost() != null && service.getSuccessSmsPhone() != null && !service.getSuccessSmsPhone().isEmpty()) {
            for (InputElement ie : data) {
                if (ie == null || ie.getKey() == null || !ie.getKey().equals(service.getSuccessSmsPhone()) || (ie.getOriginalValue() == null || ie.getOriginalValue().isEmpty()) && (ie.getValue() == null || ie.getValue().isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSelected(ScreenInit si) {
        Service service = si.getService();
        Point point = si.getPoint();
        Map<String, Object> data = si.getData();
        return SmsSuccessVerifier.isSelected(service, si.getCommission(), data);
    }

    public static boolean isSelected(Service service, Commission comm, Map<String, Object> data) {
        return !SmsSuccessVerifier.isEmptyCommission(service.getCommission()) || !SmsSuccessVerifier.isEmptyCommission(service.getMinComm()) || !SmsSuccessVerifier.isEmptyCommission(comm);
    }

    public static boolean isSelected(Service service, Point point, Commission comm, List<InputElement> data) {
        return !SmsSuccessVerifier.isEmptyCommission(service.getCommission()) || !SmsSuccessVerifier.isEmptyCommission(service.getMinComm()) || !SmsSuccessVerifier.isEmptyCommission(comm);
    }

    private static boolean isEmptyCommission(Commission commission) {
        if (commission == null) {
            return true;
        }
        TreeSet steps = commission.getSteps();
        if (commission.getPercentValue() > 0.0) {
            return false;
        }
        if (commission.getFixedValue() != null && !commission.getFixedValue().isEmpty()) {
            return false;
        }
        if (steps != null && !steps.isEmpty()) {
            return false;
        }
        HashSet units = commission.getUnits();
        if (units != null && !units.isEmpty()) {
            HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
            for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            for (CommissionUnit unit : units) {
                if (unit.getFixedValue().getSum() == 0.0) continue;
                CashUnit cu = (CashUnit)unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    coins.put(cu.getNominal(), unit.getFixedValue());
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            if (!notes.keySet().isEmpty() || !coins.keySet().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public static Sum getSmsCost(Point point) {
        Sum smsSum = null;
        NotificationProfile notificationProfile = point.getNotificationProfile();
        if (notificationProfile != null && notificationProfile.getCost() != null) {
            smsSum = new Sum(notificationProfile.getCost().intValue());
        }
        return smsSum;
    }
}

