/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.input.model.ModelEnvironment;

public class ScreenUtil {
    private static Dimension dimension;
    private static Dimension defaultDimension;

    public static void setScreenSize(String screenSize) {
        String[] d;
        if (screenSize != null && (d = screenSize.split("x")).length == 2) {
            try {
                dimension = new Dimension(Integer.parseInt(d[0]), Integer.parseInt(d[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void setScreenSize(Rectangle bounds) {
        if (dimension == null && bounds != null) {
            dimension = new Dimension(bounds.width, bounds.height);
        }
    }

    public static Dimension getScreenSize() {
        if (defaultDimension == null) {
            Logger log = Logger.getLogger((String)"gui");
            log.info((Object)"--------------------------------------------------------------");
            log.info((Object)"check screen size");
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            DisplayMode dm = gs[0].getDisplayMode();
            log.info((Object)("display mode: " + (dm == null ? dm : "present")));
            log.info((Object)("config screen size: " + dimension));
            if (dm != null) {
                defaultDimension = dimension == null ? new Dimension(dm.getWidth(), dm.getHeight()) : dimension;
            } else {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                log.info((Object)("Toolkit dimension: " + dim));
                defaultDimension = dimension == null ? dim : dimension;
            }
            log.info((Object)("default dimension=" + defaultDimension));
        }
        return defaultDimension;
    }

    public static boolean isFullScreen() {
        return false;
    }

    public static ModelEnvironment toModel(Map<String, Object> data) {
        return new ModelEnvironment(data, "CUR", 1.0, null);
    }
}

