/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RescaleOp;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static Image mixImage(Image background, Image cover, float alpha) {
        if (background == null) {
            return cover;
        }
        int bgWidth = background.getWidth(null);
        int bgHeight = background.getHeight(null);
        BufferedImage image = new BufferedImage(bgWidth, bgHeight, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.drawImage(background, 0, 0, null);
        if (cover != null) {
            int cvWidth = cover.getWidth(null);
            int cvHeight = cover.getHeight(null);
            g2d.setComposite(AlphaComposite.getInstance(3, alpha));
            g2d.drawImage(cover, (bgWidth - cvWidth) / 2, (bgHeight - cvHeight) / 2, null);
        }
        g2d.dispose();
        return image;
    }

    public static Image mixImage(Image background, Image cover, int leftMargin, float alpha) {
        int bgWidth = background.getWidth(null);
        int bgHeight = background.getHeight(null);
        BufferedImage image = new BufferedImage(bgWidth, bgHeight, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.drawImage(background, 0, 0, null);
        if (cover != null) {
            int cvWidth = cover.getWidth(null);
            int cvHeight = cover.getHeight(null);
            g2d.setComposite(AlphaComposite.getInstance(3, alpha));
            g2d.drawImage(cover, leftMargin, (bgHeight - cvHeight) / 2, null);
        }
        g2d.dispose();
        return image;
    }

    public static Image cropImage(Image image, int x, int y, int width, int height) {
        if (image == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Image");
        }
        if (x < 0 || y < 0 || width < 0 || height < 0) {
            throw new IllegalArgumentException("\u041e\u0434\u043d\u043e \u0438\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e");
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(x, y, width, height)))).getImage();
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtil.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static Icon highlightIcon(Icon sourceIcon) {
        if (sourceIcon == null) {
            return null;
        }
        ImageIcon newIcon = null;
        try {
            Image image = ((ImageIcon)sourceIcon).getImage();
            ImageIcon icon = new ImageIcon(image);
            RescaleOp op = new RescaleOp(1.25f, 0.0f, null);
            BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = bi.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            op.filter(bi, bi);
            newIcon = new ImageIcon(bi);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return newIcon;
    }
}

