/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.ScreenUtil;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.system.util.PathUtils;

public abstract class ImageStore {
    protected Map<String, SoftReference<Image>> images;
    protected Map<String, ImageIcon> icons;
    protected Map<String, Image> bgImages;
    protected Map<String, ImageIcon> operatorButtonIcons;
    protected Map<String, ImageIcon> operatorButtonIconsPress;
    protected Map<String, ImageIcon> groupButtonIcons;
    protected Map<String, ImageIcon> groupButtonIconsPress;
    protected Image groupUp;
    protected Image groupDown;
    protected Image operatorUp;
    protected Image operatorDown;
    protected Image cardUp;
    protected Image cardDown;
    private Dimension etalonSize;
    protected Dimension screenSize;
    protected float xScale;
    protected float yScale;
    protected String basePath;
    protected String menuDesignPath;
    protected String bannerPath;
    protected Map<String, SoftReference<Image>> banners;
    protected Map<String, SoftReference<ImageIcon>> gifBanners;

    protected ImageStore(String path) {
        this(path, new Dimension(1280, 1024));
    }

    protected ImageStore(String path, Dimension etalonSize) {
        if (etalonSize == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u044d\u0442\u0430\u043b\u043e\u043d\u043e\u043c \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0438");
        }
        this.basePath = SystemProp.getTerminalDir() + File.separator + "img" + File.separator + path + File.separator;
        this.bannerPath = PathUtils.getAppHome() + File.separator + "banners" + File.separator;
        this.menuDesignPath = "";
        try {
            this.menuDesignPath = ReferenceManager.getInstance().getMenu().getMenuDesign();
            this.menuDesignPath = this.menuDesignPath != null ? this.menuDesignPath + File.separator : "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.etalonSize = etalonSize;
        this.screenSize = ScreenUtil.getScreenSize();
        this.xScale = (float)(this.screenSize.getWidth() / etalonSize.getWidth());
        this.yScale = (float)(this.screenSize.getHeight() / etalonSize.getHeight());
        Logger.getLogger((String)"start").info((Object)("scale-x: " + this.xScale + ", scale-y: " + this.yScale + ", size=" + this.screenSize));
        this.images = new HashMap<String, SoftReference<Image>>();
        this.icons = new HashMap<String, ImageIcon>();
        this.operatorButtonIcons = new HashMap<String, ImageIcon>();
        this.operatorButtonIconsPress = new HashMap<String, ImageIcon>();
        this.groupButtonIcons = new HashMap<String, ImageIcon>();
        this.groupButtonIconsPress = new HashMap<String, ImageIcon>();
        this.banners = new HashMap<String, SoftReference<Image>>();
        this.gifBanners = new HashMap<String, SoftReference<ImageIcon>>();
        this.bgImages = this.createBackGround();
        this.groupUp = this.readImage("buttons/service/group.png");
        this.groupDown = this.readImage("buttons/service/group_press.png");
        this.operatorUp = this.readImage("buttons/service/operator.png");
        this.operatorDown = this.readImage("buttons/service/operator_press.png");
        this.cardUp = this.readImage("buttons/card.png");
        this.cardDown = this.readImage("buttons/card_press.png");
    }

    protected Image readImage(String path) {
        try {
            File file = this.getFile(path);
            Image image = ImageIO.read(file);
            image = image.getScaledInstance((int)((float)((Image)image).getWidth(null) * this.xScale), (int)((float)((Image)image).getHeight(null) * this.yScale), 16);
            return image;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Image getImage(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Image image = null;
        SoftReference<Image> imageRef = this.images.get(name);
        if (imageRef != null && imageRef.get() != null) {
            image = imageRef.get();
        } else {
            File file = this.getFile(name);
            if (file.exists() && file.isFile()) {
                try {
                    image = ImageIO.read(file);
                    image = image.getScaledInstance((int)((float)image.getWidth(null) * this.xScale), (int)((float)image.getHeight(null) * this.yScale), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(name, new SoftReference<Image>(image));
            }
        }
        return image;
    }

    public Image getGIFImage(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Image image = null;
        SoftReference<Image> imageRef = this.images.get(name);
        if (imageRef != null && imageRef.get() != null) {
            image = imageRef.get();
        } else {
            File file = this.getFile(name);
            if (file.exists() && file.isFile()) {
                try {
                    image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
                    image = image.getScaledInstance(Scaler.x(image.getWidth(null)), Scaler.y(image.getHeight(null)), 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(name, new SoftReference<Image>(image));
            }
        }
        return image;
    }

    public ImageIcon getIcon(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        ImageIcon icon = this.icons.get(name);
        if (icon != null) {
            return icon;
        }
        Image image = null;
        image = name.endsWith(".gif") ? this.getGIFImage(name) : this.getImage(name);
        if (image != null) {
            icon = new ImageIcon(image);
            this.icons.put(name, icon);
        }
        return icon;
    }

    public Image getBackGround(String name) {
        return this.bgImages.get(name);
    }

    protected abstract Map<String, Image> createBackGround();

    public Image getBannerBySize(String name, Integer width, Integer height) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        SoftReference<Image> sri = this.banners.get(name);
        Image image = null;
        if (sri != null && (image = sri.get()) != null) {
            return image;
        }
        File file = new File(this.bannerPath + name);
        if (file != null && file.exists()) {
            try {
                image = ImageIO.read(file);
                image = width != null && height != null ? image.getScaledInstance(width, height, 16) : image.getScaledInstance(Scaler.x(image.getWidth(null)), Scaler.y(image.getHeight(null)), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image != null) {
            this.banners.put(name, new SoftReference<Image>(image));
        }
        return image;
    }

    public ImageIcon getGIFBannerBySize(String name, Integer width, Integer height) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        SoftReference<ImageIcon> sri = this.gifBanners.get(name);
        ImageIcon image = null;
        if (sri != null && (image = sri.get()) != null) {
            return image;
        }
        File file = new File(this.bannerPath + name);
        if (file.exists()) {
            try {
                Image img = Toolkit.getDefaultToolkit().getImage(this.bannerPath + name);
                if (img != null) {
                    img = width != null && height != null ? img.getScaledInstance(width, height, 1) : img.getScaledInstance(Scaler.x(img.getWidth(null)), Scaler.y(img.getHeight(null)), 1);
                    image = new ImageIcon(img);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image != null) {
            this.gifBanners.put(name, new SoftReference<ImageIcon>(image));
        }
        return image;
    }

    protected File getFile(String name) {
        File file = new File(this.basePath + this.menuDesignPath + name);
        if (!file.exists() || !file.isFile()) {
            file = new File(this.basePath + name);
        }
        return file;
    }
}

