/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog.screen;

import java.util.Collections;
import java.util.Map;
import javax.swing.JPanel;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogTimer;
import ru.softlogic.gui.screen.shell.Shell;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.SafeScreenAdapter;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class ScreenPopupDialog
implements DialogInterface,
PopupScreen {
    private int timeout;
    private CommonScreen screen;
    private LocalScreenListener localListener;
    private ScreenListener listener;
    protected long showTime;
    protected boolean complete;
    protected Shell shell;
    private String defaultAction;
    private boolean useUserAction;

    public ScreenPopupDialog(CommonScreen screen, int timeout) {
        this(screen, timeout, null);
    }

    public ScreenPopupDialog(CommonScreen screen, int timeout, String defaultAction) {
        this(screen, timeout, defaultAction, false, null);
    }

    public ScreenPopupDialog(CommonScreen screen, int timeout, String defaultAction, boolean useUserAction, ScreenListener listener) {
        if (screen == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogPanel");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
        }
        this.screen = screen;
        this.timeout = timeout;
        this.localListener = new LocalScreenListener();
        screen.setListener(this.localListener);
        this.defaultAction = defaultAction;
        this.useUserAction = useUserAction;
        this.listener = listener;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public JPanel getPanel() {
        return this.screen.getPanel();
    }

    @Override
    public long getShowTime() {
        return this.showTime;
    }

    @Override
    public int getTimeOut() {
        return this.timeout;
    }

    @Override
    public void show(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Shell");
        }
        this.shell = shell;
        this.showTime = System.currentTimeMillis();
        DialogTimer.getInstance().addDialog(this);
        shell.showPopup(this);
        this.localListener.init();
    }

    @Override
    public void processDefaultActon() {
        this.localListener.onAction(this.defaultAction, Collections.EMPTY_MAP, null);
    }

    @Override
    public boolean isUseUserAction() {
        return this.useUserAction;
    }

    private class LocalScreenListener
    extends SafeScreenAdapter {
        private LocalScreenListener() {
        }

        private void fireAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (!ScreenPopupDialog.this.complete) {
                ScreenPopupDialog.this.complete = true;
                ScreenPopupDialog.this.shell.showPopup(null);
                if (ScreenPopupDialog.this.listener != null) {
                    ScreenPopupDialog.this.listener.onAction(action, data, cancelListener);
                }
            }
        }

        @Override
        public void onSafeAction(String action, Map<String, Object> data, Runnable cancelListener) {
            this.fireAction(action, data, cancelListener);
        }

        @Override
        public void onSafePopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
            this.fireAction("Exit", Collections.EMPTY_MAP, null);
        }
    }
}

