/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog.custom;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogTimer;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.PanelListener;
import ru.softlogic.gui.screen.shell.Shell;

public class CustomPopupDialog
implements DialogInterface,
PopupScreen {
    private int timeout;
    private Set<CustomDialogListener> listeners;
    private CustomPanel dialogPanel;
    protected long showTime;
    protected boolean complete;
    protected Shell shell;
    private Object defaultAction;
    private boolean useUserAction;

    public CustomPopupDialog(CustomPanel panel, int timeout) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogPanel");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
        }
        this.dialogPanel = panel;
        this.timeout = timeout;
        this.listeners = new HashSet<CustomDialogListener>();
        panel.setListener(new LocalPanelListener());
    }

    public CustomPopupDialog(CustomPanel panel, int timeout, Object defaultAction) {
        this(panel, timeout, defaultAction, false);
    }

    public CustomPopupDialog(CustomPanel panel, int timeout, Object defaultAction, boolean useUserAction) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogPanel");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
        }
        this.dialogPanel = panel;
        this.timeout = timeout;
        this.listeners = new HashSet<CustomDialogListener>();
        panel.setListener(new LocalPanelListener());
        this.defaultAction = defaultAction;
        this.useUserAction = useUserAction;
    }

    public void addListener(CustomDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireActionPerformed(Object data) {
        if (!this.complete) {
            this.complete = true;
            this.shell.showPopup(null);
            for (CustomDialogListener listener : this.listeners) {
                listener.onClose(data);
            }
        }
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public JPanel getPanel() {
        return this.dialogPanel.getPanel();
    }

    @Override
    public long getShowTime() {
        return this.showTime;
    }

    @Override
    public int getTimeOut() {
        return this.timeout;
    }

    @Override
    public void show(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Shell");
        }
        this.shell = shell;
        this.showTime = System.currentTimeMillis();
        DialogTimer.getInstance().addDialog(this);
        shell.showPopup(this);
    }

    @Override
    public void processDefaultActon() {
        this.fireActionPerformed(this.defaultAction);
    }

    @Override
    public boolean isUseUserAction() {
        return this.useUserAction;
    }

    private class LocalPanelListener
    implements PanelListener {
        private LocalPanelListener() {
        }

        @Override
        public void onUserAction(Object data) {
            CustomPopupDialog.this.fireActionPerformed(data);
        }
    }
}

