/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog.advanced;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogPanel;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogTimer;
import ru.softlogic.gui.screen.shell.Shell;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;

public class AdvancedBaseDialog
implements DialogScreen,
ActionListener,
PopupScreen {
    protected DialogPanel dialogPanel;
    protected DialogAction dialogAction;
    protected long showTime;
    protected boolean complete;
    protected Shell shell;

    public AdvancedBaseDialog(DialogPanel dialogPanel, DialogAction dialogAction) {
        if (dialogPanel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogPanel");
        }
        if (dialogAction == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogAction");
        }
        this.dialogPanel = dialogPanel;
        this.dialogAction = dialogAction;
        dialogPanel.setMessage(dialogAction.getMessage());
        if (dialogAction.getActionMap() != null && dialogAction.getActionMap().getActions() != null) {
            for (Action action : dialogAction.getActionMap().getActions()) {
                ClickButton cb = dialogPanel.createButton(action.getTitle());
                cb.putClientProperty("case", action.getType());
                cb.addActionListener(this);
            }
        }
    }

    @Override
    public void addListener(DialogListener listener) {
    }

    private void fireActionPerformed(String actionType) {
        if (!this.complete) {
            this.complete = true;
            this.shell.showPopup(null);
            this.dialogAction.onSelectAction(actionType);
        }
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public JPanel getPanel() {
        return this.dialogPanel.getPanel();
    }

    public DialogPanel getDialogPanel() {
        return this.dialogPanel;
    }

    @Override
    public long getShowTime() {
        return this.showTime;
    }

    @Override
    public int getTimeOut() {
        return this.dialogAction.getTimeout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ClickButton) {
            ClickButton cb = (ClickButton)e.getSource();
            this.fireActionPerformed((String)cb.getClientProperty("case"));
        }
    }

    @Override
    public void show(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Shell");
        }
        this.shell = shell;
        this.showTime = System.currentTimeMillis();
        DialogTimer.getInstance().addDialog(this);
        shell.showPopup(this);
    }

    @Override
    public void processDefaultActon() {
        this.fireActionPerformed(this.dialogAction.getDefaultAction());
    }

    @Override
    public boolean isUseUserAction() {
        return false;
    }
}

