/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.popup.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.screen.popup.PopupScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogPanel;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogTimer;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.shell.Shell;

public class BaseDialog
implements DialogScreen,
ActionListener,
PopupScreen {
    protected DialogType type;
    protected String message;
    protected int timeout;
    protected DisplayedUserCase[] cases;
    protected UserCase defaultCase;
    protected Set<DialogListener> listeners;
    protected DialogPanel dialogPanel;
    protected long showTime;
    protected boolean complete;
    protected Shell shell;
    protected JPanel panel;

    public BaseDialog(DialogPanel panel, DialogType type, String message, int timeout, DisplayedUserCase[] cases, UserCase defaultCase) {
        if (panel == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogPanel");
        }
        if (type == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DialogType");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439");
        }
        this.dialogPanel = panel;
        this.panel = panel.getPanel();
        this.type = type;
        this.message = message;
        this.timeout = timeout;
        this.cases = cases;
        this.defaultCase = defaultCase;
        this.listeners = new HashSet<DialogListener>();
        panel.setMessage(message);
        if (cases != null) {
            for (DisplayedUserCase duc : cases) {
                ClickButton button = panel.createButton(duc.getText());
                button.putClientProperty("case", (Object)duc.getUserCase());
                button.addActionListener(this);
            }
        }
    }

    @Override
    public void addListener(DialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireActionPerformed(UserCase userCase) {
        if (!this.complete) {
            this.complete = true;
            this.shell.showPopup(null);
            for (DialogListener listener : this.listeners) {
                listener.dialogClosed(userCase);
            }
        }
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public DialogPanel getDialogPanel() {
        return this.dialogPanel;
    }

    @Override
    public long getShowTime() {
        return this.showTime;
    }

    @Override
    public int getTimeOut() {
        return this.timeout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ClickButton) {
            ClickButton cb = (ClickButton)e.getSource();
            this.fireActionPerformed((UserCase)((Object)cb.getClientProperty("case")));
        }
    }

    @Override
    public void show(Shell shell) {
        if (shell == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Shell");
        }
        this.shell = shell;
        this.showTime = System.currentTimeMillis();
        DialogTimer.getInstance().addDialog(this);
        shell.showPopup(this);
    }

    @Override
    public void processDefaultActon() {
        this.fireActionPerformed(this.defaultCase);
    }

    @Override
    public boolean isUseUserAction() {
        return false;
    }
}

