/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.menu;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.components.button.LabeledClickButton;
import ru.softlogic.gui.screen.menu.TextFormatInfo;

public class MenuButtonHelper {
    public static void setTextOnButton(JButton button, String text, int width, Font font) {
        TextFormatInfo tif = MenuButtonHelper.formatText(button.getFontMetrics(font), text, width);
        for (int i = 0; i < 3 && tif.getLineCount() > 3; ++i) {
            font = font.deriveFont((float)(font.getSize() - 2));
            tif = MenuButtonHelper.formatText(button.getFontMetrics(font), text, width);
        }
        button.setFont(font);
        button.setText(tif.getText());
    }

    public static void setTextOnButtonIn3Lines(JButton button, String text, int width, Font font) {
        TextFormatInfo tif = MenuButtonHelper.formatText(button.getFontMetrics(font), text, width);
        String result = tif.getText();
        if (tif.getLineCount() > 3) {
            String[] ss = tif.getText().split("<br>");
            result = ss[0] + "<br>" + ss[1] + "<br>" + ss[2].substring(0, ss[2].length() - 4) + "...";
        }
        button.setFont(font);
        button.setText(result);
    }

    public static void setTextOnButton(JLabel label, String text, int width, Font font) {
        TextFormatInfo tif = MenuButtonHelper.formatText(label.getFontMetrics(font), text, width);
        for (int i = 0; i < 3 && tif.getLineCount() > 3; ++i) {
            font = font.deriveFont((float)(font.getSize() - 2));
            tif = MenuButtonHelper.formatText(label.getFontMetrics(font), text, width);
        }
        label.setFont(font);
        label.setText(tif.getText());
    }

    public static void setStyledTextOnButton(JLabel label, String text, int width, Font font, int lines, String lineHeight) {
        TextFormatInfo tif = MenuButtonHelper.formatText(label.getFontMetrics(font), text, width, lineHeight);
        String result = tif.getText();
        if (tif.getLineCount() > lines) {
            String[] ss = tif.getText().split("<br>");
            for (int i = 0; i < lines - 1; ++i) {
                result = result + ss[i] + "<br>";
            }
            result = result + ss[lines].substring(0, ss[lines].length() - 4) + "...";
        }
        label.setFont(font);
        label.setText(result);
    }

    public static void setTextOnButton(LabeledClickButton button, String text, int width, Font font) {
        TextFormatInfo tif = MenuButtonHelper.formatText(button.getFontMetrics(font), text, width);
        for (int i = 0; i < 3 && tif.getLineCount() > 3; ++i) {
            font = font.deriveFont((float)(font.getSize() - 2));
            tif = MenuButtonHelper.formatText(button.getFontMetrics(font), text, width);
        }
        button.getJLabel().setFont(font);
        button.getJLabel().setText(tif.getText());
    }

    public static void setTextOnButton(IconifiedClickButton button, String text, int width, Font font) {
        TextFormatInfo tif = MenuButtonHelper.formatText(button.getTitleLabel().getFontMetrics(font), text, width);
        for (int i = 0; i < 3 && tif.getLineCount() > 3; ++i) {
            font = font.deriveFont((float)(font.getSize() - 2));
            tif = MenuButtonHelper.formatText(button.getTitleLabel().getFontMetrics(font), text, width);
        }
        button.getTitleLabel().setFont(font);
        button.getTitleLabel().setText(tif.getText());
    }

    public static void setTextOnLabel(JLabel label, String text, int width, Font font, int maxLineCount) {
        String nText = text;
        if (width > 0) {
            TextFormatInfo tif = MenuButtonHelper.formatTextWitCustomAlign(label.getFontMetrics(font), text, width, "", null);
            if (font != null) {
                float fontsize;
                for (int i = 0; i < 15 && (tif.getMaxLineSize() > width || tif.getLineCount() > maxLineCount && maxLineCount > 0) && !((fontsize = (float)(font.getSize() - 1)) < 1.0f); ++i) {
                    font = font.deriveFont(fontsize);
                    tif = MenuButtonHelper.formatTextWitCustomAlign(label.getFontMetrics(font), text, width, "", null);
                }
                label.setFont(font);
            }
            nText = tif.getText();
        }
        label.setText(nText);
    }

    public static TextFormatInfo formatText(FontMetrics fm, String text, int width, String lineHeight) {
        return MenuButtonHelper.formatTextWitCustomAlign(fm, text, width, lineHeight, "center");
    }

    public static TextFormatInfo formatTextWitCustomAlign(FontMetrics fm, String text, int width, String lineHeight, String align) {
        String current = "";
        int maxWidth = 0;
        if ((double)fm.stringWidth(text) > (double)width * 0.95) {
            String[] strs = text.split(" |-");
            LinkedList<String> list = new LinkedList<String>();
            for (String str : strs) {
                if (maxWidth < fm.stringWidth(str)) {
                    maxWidth = fm.stringWidth(str);
                }
                if ((double)fm.stringWidth(str) > (double)width * 0.95) {
                    list.add(current);
                    current = "";
                    list.add(str);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if ((double)fm.stringWidth(stringBuilder.append(current).append(str).toString()) > (double)width * 0.95) {
                    list.add(current);
                    current = str;
                    continue;
                }
                current = current + " " + str;
            }
            if (!current.isEmpty()) {
                list.add(current);
            }
            current = "";
            for (String str : list) {
                str = str.trim();
                if (current.isEmpty()) {
                    current = str;
                    continue;
                }
                if (str.isEmpty()) continue;
                current = current + "<br>" + str.trim();
            }
            String LineHStyle = "";
            if (!lineHeight.isEmpty()) {
                LineHStyle = " style='line-height:" + lineHeight + "'";
            }
            if (current.contains("<html>")) {
                return new TextFormatInfo(current, list.size(), maxWidth);
            }
            return new TextFormatInfo("<html><p " + (align != null && !align.isEmpty() ? "align='" + align + "'" : "") + LineHStyle + ">" + current, list.size(), maxWidth);
        }
        return new TextFormatInfo(text, 1, maxWidth);
    }

    public static TextFormatInfo formatText(FontMetrics fm, String text, int width) {
        return MenuButtonHelper.formatText(fm, text, width, "");
    }
}

