/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.communal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.cash.Sum;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.srv.api.communal.ServiceDescriptor;
import ru.softlogic.srv.api.communal.ServiceGroup;

public class CommunalHelper {
    public static boolean hasServices(ServiceGroup sg, Boolean active) {
        if (sg == null) {
            return false;
        }
        if (sg.getServices() != null && sg.getServices().size() > 0) {
            if (active == null) {
                return true;
            }
            for (ServiceDescriptor sd : sg.getServices()) {
                if (sd.isActive() != active.booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                if (!CommunalHelper.hasServices(sg1, active)) continue;
                return true;
            }
        }
        return false;
    }

    public static Sum getTotalSum(ServiceGroup sg, Boolean active) {
        Sum total = new Sum();
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (sd.getSumPurchase() == null || (active == null || sd.isActive() != active.booleanValue()) && active != null) continue;
                total = total.add(sd.getSumPurchase());
            }
        }
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                total = total.add(CommunalHelper.getTotalSum(sg1, active));
            }
        }
        return total;
    }

    public static void setActiveIfHasSum(ServiceGroup sg) {
        Sum total = new Sum();
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (sd.getSumPurchase() == null || sd.getSumPurchase().isEmpty()) continue;
                sd.setActive(true);
            }
        }
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                CommunalHelper.setActiveIfHasSum(sg1);
            }
        }
    }

    public static ServiceDescriptor getFirstActiveService(ServiceGroup sg) {
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (!sd.isActive()) continue;
                return sd;
            }
        }
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                ServiceDescriptor sd = CommunalHelper.getFirstActiveService(sg1);
                if (sd == null) continue;
                return sd;
            }
        }
        return null;
    }

    public static int getListSize(ServiceGroup sg, Boolean active) {
        int count = 0;
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                if (!CommunalHelper.hasServices(sg1, active)) continue;
                ++count;
            }
        }
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (active != null && sd.isActive() != active.booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public static List<Object> getList(ServiceGroup sg, Boolean active) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                if (!CommunalHelper.hasServices(sg1, active)) continue;
                list.add(sg1);
            }
        }
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (active != null && sd.isActive() != active.booleanValue()) continue;
                list.add(sd);
            }
        }
        return list;
    }

    public static List<ServiceDescriptor> getServiceList(ServiceGroup sg, Boolean active) {
        LinkedList<ServiceDescriptor> list = new LinkedList<ServiceDescriptor>();
        if (sg != null && sg.getGroups() != null) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                if (!CommunalHelper.hasServices(sg1, active)) continue;
                list.addAll(CommunalHelper.getServiceList(sg1, active));
            }
        }
        if (sg != null && sg.getServices() != null) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (active != null && sd.isActive() != active.booleanValue()) continue;
                list.add(sd);
            }
        }
        return list;
    }

    public static Sum addChildServices(ServiceGroup sg, List<ChildOperation> list, Sum sumOut) {
        if (sg == null) {
            return null;
        }
        if (sumOut == null) {
            return null;
        }
        if (sumOut.isEmpty()) {
            return sumOut;
        }
        if (sg.getServices() != null && sg.getServices().size() > 0) {
            for (ServiceDescriptor sd : sg.getServices()) {
                if (!sd.isActive() || sd.getSumPurchase() == null || sd.getSumPurchase().isEmpty()) continue;
                if (sumOut.isEmpty()) {
                    return sumOut;
                }
                ChildOperation op = new ChildOperation();
                op.setService(sd.getService());
                if (sumOut.compareTo(sd.getSumPurchase()) > 0) {
                    op.setSumOutcome(sd.getSumPurchase());
                    sumOut = sumOut.sub(sd.getSumPurchase());
                } else {
                    op.setSumOutcome(sumOut);
                    sumOut = new Sum();
                }
                HashMap form = new HashMap();
                form.putAll(sd.getForm());
                op.setForm(form);
                list.add(op);
            }
        }
        if (sg.getGroups() != null && sg.getServices().size() > 0) {
            for (ServiceGroup sg1 : sg.getGroups()) {
                sumOut = CommunalHelper.addChildServices(sg1, list, sumOut);
            }
        }
        return sumOut;
    }
}

