/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.bilektron;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ru.softlogic.gui.screen.content.bilektron.Hall;
import ru.softlogic.gui.screen.content.bilektron.Session;
import ru.softlogic.gui.screen.content.bilektron.SessionData;
import ru.softlogic.gui.screen.content.bilektron.SessionFactory;
import ru.softlogic.gui.screen.content.bilektron.SessionPanelListener;
import ru.softlogic.gui.screen.content.bilektron.Show;
import ru.softlogic.gui.utils.Scaler;

public class SessionPanel {
    private JPanel panel;
    private SessionFactory factory;
    private List<JToggleButton> buttons;
    private LocalActionListener listener;
    private List<SessionPanelListener> listeners;

    public SessionPanel(SessionFactory factory) {
        this.factory = factory;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.buttons = new LinkedList<JToggleButton>();
        this.listener = new LocalActionListener();
        this.listeners = new LinkedList<SessionPanelListener>();
    }

    public void init(SessionData sessionData) {
        this.buttons.clear();
        this.panel.setVisible(false);
        this.panel.removeAll();
        TableLayout layout = new TableLayout();
        double wdt = Scaler.x(58);
        layout.setColumn(new double[]{Scaler.x(7), Scaler.x(12), Scaler.x(250), Scaler.x(7), wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, wdt, Scaler.x(7)});
        int cnt = 0;
        for (Session s : sessionData.getSessions()) {
            cnt += s.getHalls().length;
        }
        double[] rows = new double[cnt * 2 + sessionData.getSessions().length + 2];
        int pos = 0;
        rows[pos++] = Scaler.y(7);
        for (Session s : sessionData.getSessions()) {
            rows[pos++] = Scaler.y(50);
            for (int j = 0; j < s.getHalls().length; ++j) {
                rows[pos++] = Scaler.y(50);
                rows[pos++] = Scaler.y(20);
            }
        }
        rows[pos++] = Scaler.y(7);
        layout.setRow(rows);
        this.panel.setLayout((LayoutManager)layout);
        pos = 1;
        for (Session session : sessionData.getSessions()) {
            this.panel.add((Component)this.factory.createTitleLabel(session.getTitle()), "1," + pos + ",17," + pos);
            ++pos;
            for (int i = 0; i < session.getHalls().length; ++i) {
                Hall h = session.getHalls()[i];
                this.panel.add((Component)this.factory.createHallLabel(h.getName()), "2," + pos);
                for (int j = 0; j < h.getShows().length && j < 13; ++j) {
                    Show s = h.getShows()[j];
                    JToggleButton btn = this.factory.createShowButton(s);
                    btn.addActionListener(this.listener);
                    this.buttons.add(btn);
                    this.panel.add((Component)btn, "" + (j + 4) + "," + pos + "");
                }
                pos += 2;
            }
        }
        this.panel.setVisible(true);
    }

    public void addListener(SessionPanelListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void resetButtons() {
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private class LocalActionListener
    implements ActionListener {
        private LocalActionListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    Show show = null;
                    if (tb.isSelected()) {
                        for (JToggleButton btn : SessionPanel.this.buttons) {
                            if (tb == btn) continue;
                            btn.setSelected(false);
                        }
                        show = (Show)tb.getClientProperty("show");
                    }
                    for (SessionPanelListener spl : SessionPanel.this.listeners) {
                        spl.onSelect(show);
                    }
                }
            });
        }
    }
}

