/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.barcode.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Properties;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.screen.content.barcode.parser.AutoInfoEncoder;
import ru.softlogic.gui.screen.content.barcode.parser.BarcodeData;
import ru.softlogic.gui.screen.content.barcode.parser.BarcodeParser;

public class AutoInfoParser
implements BarcodeParser {
    @Override
    public BarcodeData parce(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        data = data.replaceAll("; ", "\n").trim();
        Properties prop = new Properties();
        try {
            prop.load(new StringReader(data));
        }
        catch (IOException ex) {
            return null;
        }
        String fio = prop.getProperty("fio");
        if (fio == null || fio.isEmpty()) {
            return null;
        }
        String city = prop.getProperty("city");
        if (city == null || city.isEmpty()) {
            return null;
        }
        String address = prop.getProperty("adres");
        if (address == null || address.isEmpty()) {
            return null;
        }
        String price = prop.getProperty("price");
        if (price == null || price.isEmpty()) {
            return null;
        }
        Sum sum = null;
        try {
            int pr = Integer.parseInt(price);
            if (pr == 0) {
                return null;
            }
            sum = new Sum(pr);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("fio", AutoInfoEncoder.process(fio));
        result.put("city", AutoInfoEncoder.process(city));
        result.put("address", AutoInfoEncoder.process(address));
        BarcodeData barcodeData = new BarcodeData();
        barcodeData.setSumTrade(sum);
        barcodeData.setData(result);
        return barcodeData;
    }
}

